/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractTemplateCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.springsource.ide.eclipse.commons.frameworks.core.workspace.ClasspathListenerManager;

public class BootTemplateCompletionProposalComputer
extends AbstractTemplateCompletionProposalComputer {
    private static final String CONTEXT_TYPE_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private final TemplateEngine fAllTemplateEngine;
    private final TemplateEngine fMembersTemplateEngine;
    private final TemplateEngine fStatementsTemplateEngine;
    private IJavaProject fCachedJavaProject;
    private boolean fIsContextTypeOnClasspath;

    public BootTemplateCompletionProposalComputer() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        this.fAllTemplateEngine = BootTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "boot");
        this.fMembersTemplateEngine = BootTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "boot-members");
        this.fStatementsTemplateEngine = BootTemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "boot-statements");
        new ClasspathListenerManager(javaProject -> this.setCachedJavaProject(null));
    }

    private static TemplateEngine createTemplateEngine(ContextTypeRegistry templateContextRegistry, String contextTypeId) {
        TemplateContextType contextType = templateContextRegistry.getContextType(contextTypeId);
        Assert.isNotNull((Object)contextType);
        return new TemplateEngine(contextType);
    }

    protected TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        if (this.isContextTypeOnClasspath(javaProject)) {
            CompletionContext coreContext = context.getCoreContext();
            if (coreContext != null) {
                int tokenLocation = coreContext.getTokenLocation();
                if ((tokenLocation & 1) != 0) {
                    return this.fMembersTemplateEngine;
                }
                if ((tokenLocation & 2) != 0) {
                    return this.fStatementsTemplateEngine;
                }
            }
            return this.fAllTemplateEngine;
        }
        return null;
    }

    private synchronized boolean isContextTypeOnClasspath(IJavaProject javaProject) {
        if (!javaProject.equals(this.fCachedJavaProject)) {
            this.fCachedJavaProject = javaProject;
            try {
                IType type = javaProject.findType(CONTEXT_TYPE_NAME);
                this.fIsContextTypeOnClasspath = type != null;
            }
            catch (JavaModelException javaModelException) {
                this.fIsContextTypeOnClasspath = false;
            }
        }
        return this.fIsContextTypeOnClasspath;
    }

    private synchronized void setCachedJavaProject(IJavaProject project) {
        this.fCachedJavaProject = project;
    }
}

