/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.imports.internal.statics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.imports.ImportsActivator;
import org.springframework.ide.eclipse.imports.internal.statics.StaticImportCatalogue;

public class SpringStaticImportFavourites {
    public static final String SPRING_IDE_IMPORT_STATICS_INSTANCE_SCOPE = "org.springframework.ide.eclipse.imports.importStaticsInstanceScope";
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS = SpringStaticImportFavourites.getJDTUIKey("content_assist_favorite_static_members");
    private static final OptionsConfigurationBlock.Key PREF_SPRING_IDE_IMPORT_STATICS_INSTANCE_SCOPE = SpringStaticImportFavourites.getSpringIDEImportStaticsKey("org.springframework.ide.eclipse.imports.importStaticsInstanceScope");
    private static final String WILDCARD = ".*";
    private IWorkingCopyManager manager;
    private final StaticImportCatalogue importStaticsCatalogue;

    public SpringStaticImportFavourites(StaticImportCatalogue importStaticsCatalogue) {
        this.importStaticsCatalogue = importStaticsCatalogue;
        this.manager = new WorkingCopyManager();
    }

    public void asynchLoad() {
        Job job = new Job("Loading Spring static imports into Eclipse code assist favourites"){

            protected IStatus run(IProgressMonitor monitor) {
                SpringStaticImportFavourites.this.load();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    public void load() {
        this.writeDefaultScopedImports(this.importStaticsCatalogue);
        this.writeInstanceScopedImports(this.importStaticsCatalogue);
    }

    protected static OptionsConfigurationBlock.Key getKey(String plugin, String key) {
        return new OptionsConfigurationBlock.Key(plugin, key);
    }

    public String[] getStoredImportStatics(IScopeContext context) {
        String str = PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS.getStoredValue(context, this.manager);
        if (str != null && str.length() > 0) {
            return this.deserializeFavorites(str);
        }
        return new String[0];
    }

    private String[] deserializeFavorites(String str) {
        return str.split(";");
    }

    private static String serializeFavorites(List<String> favorites) {
        int size = favorites.size();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size) {
            buf.append(favorites.get(i));
            if (i < size - 1) {
                buf.append(';');
            }
            ++i;
        }
        return buf.toString();
    }

    protected static final OptionsConfigurationBlock.Key getJDTUIKey(String key) {
        return SpringStaticImportFavourites.getKey("org.eclipse.jdt.ui", key);
    }

    protected static OptionsConfigurationBlock.Key getSpringIDEImportStaticsKey(String key) {
        return SpringStaticImportFavourites.getKey("org.springframework.ide.eclipse.imports", key);
    }

    protected List<String> mergeWithExisting(List<String> favorites, IScopeContext context) {
        String[] existing = this.getStoredImportStatics(context);
        ArrayList<String> merged = new ArrayList<String>(Arrays.asList(existing));
        for (String fav : favorites) {
            if (merged.contains(fav)) continue;
            merged.add(fav);
        }
        return merged;
    }

    protected void writeDefaultScopedImports(StaticImportCatalogue catalogue) {
        List<String> validated = this.getValidated(catalogue.getCatalogue());
        List<String> merged = this.mergeWithExisting(validated, DefaultScope.INSTANCE);
        new FavouritesPreferenceWriter(merged, this.manager, DefaultScope.INSTANCE).write();
    }

    protected void writeInstanceScopedImports(StaticImportCatalogue catalogue) {
        String writtenVal = PREF_SPRING_IDE_IMPORT_STATICS_INSTANCE_SCOPE.getStoredValue(InstanceScope.INSTANCE, this.manager);
        if (writtenVal == null || !Boolean.parseBoolean(writtenVal)) {
            List<String> validated = this.getValidated(catalogue.getCatalogue());
            List<String> merged = this.mergeWithExisting(validated, InstanceScope.INSTANCE);
            new FavouritesPreferenceWriter(merged, this.manager, InstanceScope.INSTANCE).write();
            new PreferenceWriter(Boolean.toString(true), PREF_SPRING_IDE_IMPORT_STATICS_INSTANCE_SCOPE, this.manager, InstanceScope.INSTANCE).write();
        }
    }

    protected List<String> getValidated(String[] original) {
        ArrayList<String> validated = new ArrayList<String>();
        String[] stringArray = original;
        int n = original.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            IStatus status = JavaConventions.validateJavaTypeName((String)val, (String)"1.3", (String)"1.3");
            if (status.isOK()) {
                validated.add(this.asWildCard(val));
            } else {
                ImportsActivator.log(status);
            }
            ++n2;
        }
        return validated;
    }

    protected String asWildCard(String val) {
        return String.valueOf(val) + WILDCARD;
    }

    class FavouritesPreferenceWriter
    extends PreferenceWriter {
        public FavouritesPreferenceWriter(List<String> values, IWorkingCopyManager manager, IScopeContext context) {
            super(SpringStaticImportFavourites.serializeFavorites(values), PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS, manager, context);
        }
    }

    class PreferenceWriter {
        protected final IWorkingCopyManager manager;
        protected final IScopeContext context;
        protected final String values;
        protected final OptionsConfigurationBlock.Key key;

        public PreferenceWriter(String values, OptionsConfigurationBlock.Key key, IWorkingCopyManager manager, IScopeContext context) {
            this.manager = manager;
            this.context = context;
            this.values = values;
            this.key = key;
        }

        public void write() {
            this.write(this.key, this.values, this.context);
            this.applyChanges();
        }

        protected String write(OptionsConfigurationBlock.Key key, String value, IScopeContext context) {
            String oldValue = key.getStoredValue(context, this.manager);
            key.setStoredValue(context, value, this.manager);
            return oldValue;
        }

        protected void applyChanges() {
            try {
                this.manager.applyChanges();
            }
            catch (BackingStoreException e) {
                ImportsActivator.log(e);
            }
        }
    }
}

