/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigSectionPart;

public abstract class AbstractConfigDetailsPart
extends AbstractFormPart
implements IDetailsPage {
    private AbstractConfigMasterPart master;
    private AbstractConfigEditor cEditor;
    protected FormToolkit toolkit;
    protected AbstractConfigSectionPart detailsSection;
    private IDOMElement input;

    public AbstractConfigDetailsPart(AbstractConfigMasterPart master) {
        this.master = master;
        if (master != null) {
            this.cEditor = master.getConfigEditor();
        }
    }

    protected void alignSectionHeaderWithMaster(Section section) {
        Section masterSection;
        if (this.master != null && (masterSection = this.master.getSection()) != null) {
            section.descriptionVerticalSpacing += masterSection.getTextClientHeightDifference();
        }
    }

    public void createContents(Composite parent) {
        this.toolkit = this.getManagedForm().getToolkit();
        parent.setLayout((Layout)new GridLayout());
        if (this.getMasterViewer() != null) {
            this.updateInput(this.getMasterViewer().getSelection());
        }
        this.createDetailsSection(parent);
    }

    protected Composite createDetailsClient(Section details) {
        details.setLayout((Layout)new GridLayout());
        details.setLayoutData((Object)new GridData(1808));
        details.setText(this.getDetailsSectionTitle());
        details.setDescription(this.getDetailsSectionDescription());
        Composite detailsClient = this.toolkit.createComposite((Composite)details);
        detailsClient.setLayout((Layout)new GridLayout());
        detailsClient.setLayoutData((Object)new GridData(1808));
        details.setClient((Control)detailsClient);
        return detailsClient;
    }

    protected abstract void createDetailsContent(Composite var1);

    protected void createDetailsSection(Composite parent) {
        this.detailsSection = this.createDetailsSectionPart(this.getConfigEditor(), this.getInput(), parent, this.toolkit);
        this.detailsSection.createContent();
        this.alignSectionHeaderWithMaster(this.detailsSection.getSection());
    }

    protected AbstractConfigSectionPart createDetailsSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        final Section details = toolkit.createSection(parent, 384);
        return new AbstractConfigSectionPart(this.cEditor, input, details){

            @Override
            public void createContent() {
                Composite detailsClient = AbstractConfigDetailsPart.this.createDetailsClient(details);
                AbstractConfigDetailsPart.this.createDetailsContent(detailsClient);
            }
        };
    }

    public AbstractConfigEditor getConfigEditor() {
        return this.cEditor;
    }

    public AbstractConfigSectionPart getDetailsSection() {
        return this.detailsSection;
    }

    protected abstract String getDetailsSectionDescription();

    protected abstract String getDetailsSectionTitle();

    public IDOMElement getInput() {
        return this.input;
    }

    public AbstractConfigMasterPart getMasterPart() {
        return this.master;
    }

    protected ColumnViewer getMasterViewer() {
        if (this.master != null) {
            return this.master.getViewer();
        }
        return null;
    }

    public void refresh() {
        if (this.detailsSection != null) {
            this.detailsSection.refresh();
        }
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.updateInput(selection);
        this.refresh();
    }

    public void setConfigEditor(AbstractConfigEditor editor) {
        this.cEditor = editor;
    }

    public void setMasterPart(AbstractConfigMasterPart master) {
        if (this.master != null) {
            this.master.dispose();
        }
        this.master = master;
        if (master != null) {
            this.cEditor = master.getConfigEditor();
        }
    }

    protected void updateInput(ISelection selection) {
        IDOMElement oldInput = this.input;
        this.input = null;
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel != null) {
            Object obj = sel.getFirstElement();
            if (obj instanceof ActivityPart) {
                ActivityPart activity = (ActivityPart)obj;
                obj = activity.getModelElement().getInput();
            }
            if (obj instanceof IDOMElement) {
                this.input = obj != oldInput ? (IDOMElement)obj : oldInput;
            }
        }
        if (this.detailsSection != null) {
            this.detailsSection.setFormInput(this.input);
        }
    }
}

