/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigLabelProvider;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigContentProvider;

public abstract class AbstractConfigMasterPart
extends SectionPart {
    private final AbstractConfigFormPage page;
    protected FormToolkit toolkit;
    private ToolBarManager toolBarManager;
    private ColumnViewer viewer;
    private SpringConfigContentProvider contentProv;
    private AbstractConfigLabelProvider labelProv;

    public AbstractConfigMasterPart(AbstractConfigFormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.page = page;
        this.toolkit = page.getManagedForm().getToolkit();
    }

    protected abstract void createButtons(Composite var1);

    protected void createContents() {
        GridData data = new GridData(1808);
        data.minimumWidth = 250;
        data.grabExcessVerticalSpace = true;
        Section section = this.getSection();
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)data);
        section.setText(this.getSectionTitle());
        section.setDescription(this.getSectionDescription());
        Composite client = this.toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)client);
        this.toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = this.toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        section.setTextClient((Control)toolbar);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        data = new GridData(1808);
        data.heightHint = 50;
        data.widthHint = 50;
        this.contentProv = this.createViewerContentProvider();
        this.labelProv = this.createViewerLabelProvider();
        this.viewer = this.createViewer(client);
        this.viewer.setContentProvider((IContentProvider)this.contentProv);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProv);
        this.viewer.setInput((Object)this.getConfigEditor().getDomDocument());
        MenuManager menuMgr = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractConfigMasterPart.this.fillContextMenu(manager);
            }
        };
        menuMgr.addMenuListener(listener);
        menuMgr.setRemoveAllWhenShown(true);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractConfigMasterPart.this.getManagedForm().fireSelectionChanged((IFormPart)AbstractConfigMasterPart.this, event.getSelection());
            }
        });
        this.viewer.getControl().setLayoutData((Object)data);
        Composite buttonComp = this.toolkit.createComposite(client);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(2));
        this.createButtons(buttonComp);
        this.postCreateContents();
        this.toolBarManager.update(true);
    }

    protected abstract ColumnViewer createViewer(Composite var1);

    protected abstract SpringConfigContentProvider createViewerContentProvider();

    protected abstract AbstractConfigLabelProvider createViewerLabelProvider();

    protected abstract void fillContextMenu(IMenuManager var1);

    public AbstractConfigEditor getConfigEditor() {
        return this.page.getEditor();
    }

    public AbstractConfigFormPage getFormPage() {
        return this.page;
    }

    protected abstract String getSectionDescription();

    protected abstract String getSectionTitle();

    protected ToolBarManager getToolBarManager() {
        return this.toolBarManager;
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    protected SpringConfigContentProvider getViewerContentProvider() {
        return this.contentProv;
    }

    protected abstract void postCreateContents();

    public void refresh() {
        this.viewer.refresh();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.viewer.getSelection());
        super.refresh();
    }
}

