/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringConfigInputAccessor {
    private final AbstractConfigEditor editor;
    private final IDOMElement input;
    private final ShallowFormatProcessorXML formatter;

    public SpringConfigInputAccessor(AbstractConfigEditor editor, IDOMElement input) {
        this.editor = editor;
        this.input = input;
        this.formatter = new ShallowFormatProcessorXML();
    }

    public void editAttribute(String attrName, String newValue) {
        if (this.input != null && this.input.getParentNode() != null) {
            StructuredTextViewer textView = this.editor.getTextViewer();
            this.input.getModel().beginRecording((Object)textView);
            String existingValue = this.getAttributeValue(attrName);
            if (newValue == null || newValue.trim().equals("")) {
                if (existingValue != null && !existingValue.trim().equals("")) {
                    this.input.removeAttribute(attrName);
                    this.formatter.formatNode((Node)this.input);
                }
            } else if (!newValue.equals(existingValue)) {
                this.input.setAttribute(attrName, newValue);
                this.formatter.formatNode((Node)this.input);
            }
            this.input.getModel().endRecording((Object)textView);
        }
    }

    public void editElement(String elemValue) {
        if (this.input != null) {
            NodeList list = this.input.getChildNodes();
            CharacterData textNode = null;
            int i = 0;
            while (i < list.getLength()) {
                IDOMText text;
                if (list.item(i) instanceof IDOMText && !(text = (IDOMText)list.item(i)).isElementContentWhitespace()) {
                    textNode = text;
                    break;
                }
                ++i;
            }
            if (elemValue == null || elemValue.trim().equals("")) {
                if (textNode != null && !textNode.getData().trim().equals("")) {
                    this.input.removeChild((Node)textNode);
                }
            } else {
                if (textNode == null) {
                    textNode = this.input.getOwnerDocument().createTextNode("");
                    this.input.appendChild((Node)textNode);
                }
                if (!elemValue.equals(textNode.getData())) {
                    textNode.setData(elemValue);
                }
            }
        }
    }

    public String getAttributeValue(String attr) {
        String value;
        if (this.input != null && this.input.getAttributeNode(attr) != null && (value = this.input.getAttribute(attr)) != null) {
            return value;
        }
        return "";
    }

    public String getElementValue() {
        if (this.input != null) {
            NodeList list = this.input.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                IDOMText text;
                if (list.item(i) instanceof IDOMText && !(text = (IDOMText)list.item(i)).isElementContentWhitespace()) {
                    return text.getData();
                }
                ++i;
            }
        }
        return "";
    }
}

