/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph.model;

import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.AlternateTransition;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.IntegrationDiagram;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractChannelModelElement
extends Activity {
    public AbstractChannelModelElement() {
    }

    public AbstractChannelModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    protected void createInput(String uri) {
        super.createInput(uri);
        this.getInput().setAttribute(IntegrationSchemaConstants.ATTR_ID, this.getNewChannelId());
    }

    public String getInputName() {
        return IntegrationSchemaConstants.ELEM_CHANNEL;
    }

    private String getNewChannelId() {
        String id = String.valueOf(this.getInputName()) + ((IntegrationDiagram)this.getDiagram()).getNewChannelId();
        Node ref = this.getDiagram().getReferencedNode(id);
        if (ref instanceof IDOMElement) {
            return this.getNewChannelId();
        }
        return id;
    }

    protected List<Transition> getOutgoingTransitionsFromXml() {
        List list = super.getOutgoingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList interceptors = this.getInput().getChildNodes();
        int i = 0;
        while (i < interceptors.getLength()) {
            Node iNode = interceptors.item(i);
            if (iNode instanceof IDOMElement && iNode.getLocalName().equals(IntegrationSchemaConstants.ELEM_INTERCEPTORS)) {
                IDOMElement interceptor = (IDOMElement)iNode;
                NodeList wiretaps = interceptor.getChildNodes();
                int w = 0;
                while (w < wiretaps.getLength()) {
                    Node channelRef;
                    IDOMElement wiretap;
                    String channel;
                    Node wNode = wiretaps.item(w);
                    if (wNode instanceof IDOMElement && wNode.getLocalName().equals(IntegrationSchemaConstants.ELEM_WIRE_TAP) && (channel = (wiretap = (IDOMElement)wNode).getAttribute(IntegrationSchemaConstants.ATTR_CHANNEL)) != null && channel.trim().length() > 0 && (channelRef = this.getDiagram().getReferencedNode(channel)) != null) {
                        for (Activity activity : registry) {
                            if (activity instanceof ParallelActivity || !activity.getInput().equals(channelRef)) continue;
                            AlternateTransition trans = new AlternateTransition(this, activity, (IDOMNode)wiretap);
                            list.add(trans);
                        }
                    }
                    ++w;
                }
            }
            ++i;
        }
        return list;
    }
}

