/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class AvoidModifiersForTypesCheck
extends Check {
    public static final String MSG_KEY = "avoid.modifiers.for.types";
    private Pattern forbiddenClassesRegexpFinal = Pattern.compile("");
    private Pattern forbiddenClassesRegexpStatic = Pattern.compile("ULC.+");
    private Pattern forbiddenClassesRegexpTransient = Pattern.compile("");
    private Pattern forbiddenClassesRegexpVolatile = Pattern.compile("");

    public void setForbiddenClassesRegexpStatic(String forbiddenClassesRegexpStatic) {
        String regexp = forbiddenClassesRegexpStatic == null ? "" : forbiddenClassesRegexpStatic;
        this.forbiddenClassesRegexpStatic = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpFinal(String forbiddenClassesRegexpFinal) {
        String regexp = forbiddenClassesRegexpFinal == null ? "" : forbiddenClassesRegexpFinal;
        this.forbiddenClassesRegexpFinal = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpTransient(String forbiddenClassesRegexpTransient) {
        String regexp = forbiddenClassesRegexpTransient == null ? "" : forbiddenClassesRegexpTransient;
        this.forbiddenClassesRegexpTransient = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpVolatile(String forbiddenClassesRegexpVolatile) {
        String regexp = forbiddenClassesRegexpVolatile == null ? "" : forbiddenClassesRegexpVolatile;
        this.forbiddenClassesRegexpVolatile = Pattern.compile(regexp);
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST ast) {
        String classNameAndPath = AvoidModifiersForTypesCheck.getClassNameAndPath(ast);
        if (classNameAndPath != null) {
            String className = AvoidModifiersForTypesCheck.getClassName(classNameAndPath);
            block6: for (int modifierType : AvoidModifiersForTypesCheck.getModifiers(ast)) {
                switch (modifierType) {
                    case 64: {
                        if (!this.forbiddenClassesRegexpStatic.matcher(className).matches()) continue block6;
                        this.log(ast, MSG_KEY, new Object[]{className, "static"});
                        continue block6;
                    }
                    case 39: {
                        if (!this.forbiddenClassesRegexpFinal.matcher(className).matches()) continue block6;
                        this.log(ast, MSG_KEY, new Object[]{className, "final"});
                        continue block6;
                    }
                    case 65: {
                        if (!this.forbiddenClassesRegexpTransient.matcher(className).matches()) continue block6;
                        this.log(ast, MSG_KEY, new Object[]{className, "transient"});
                        continue block6;
                    }
                    case 68: {
                        if (!this.forbiddenClassesRegexpVolatile.matcher(className).matches()) continue block6;
                        this.log(ast, MSG_KEY, new Object[]{className, "volatile"});
                        continue block6;
                    }
                }
                Utils.reportInvalidToken(modifierType);
            }
        }
    }

    private static String getClassNameAndPath(DetailAST variableDefNode) {
        String result = null;
        DetailAST type = variableDefNode.findFirstToken(13);
        DetailAST textWithoutDots = type.findFirstToken(58);
        if (textWithoutDots == null) {
            DetailAST parentDotAST = type.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = textWithoutDots.getText();
        }
        return result;
    }

    private static String getClassName(String classNameAndPath) {
        return classNameAndPath.replaceAll(".+\\.", "");
    }

    private static List<Integer> getModifiers(DetailAST variableDefAst) {
        LinkedList<Integer> modifiersList = new LinkedList<Integer>();
        DetailAST modifiersAST = variableDefAst.findFirstToken(5);
        for (DetailAST modifier : AvoidModifiersForTypesCheck.getChildren(modifiersAST)) {
            modifiersList.add(modifier.getType());
        }
        return modifiersList;
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

