/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class UnnecessaryParenthesesExtendedCheck
extends Check {
    public static final String MSG_KEY_ASSIGN = "unnecessary.paren.assign";
    public static final String MSG_KEY_EXPR = "unnecessary.paren.expr";
    public static final String MSG_KEY_IDENT = "unnecessary.paren.ident";
    public static final String MSG_KEY_LITERAL = "unnecessary.paren.literal";
    public static final String MSG_KEY_RETURN = "unnecessary.paren.return";
    public static final String MSG_KEY_STRING = "unnecessary.paren.string";
    private static final int MIN_CHILDREN_FOR_MATCH = 3;
    private static final int MAX_QUOTED_LENGTH = 25;
    private boolean ignoreCalculationOfBooleanVariables;
    private boolean ignoreCalculationOfBooleanVariablesWithReturn;
    private boolean ignoreCalculationOfBooleanVariablesWithAssert;
    private static final int[] LITERALS = new int[]{142, 140, 137, 141, 139, 135, 134, 133};
    private static final int[] ASSIGNMENTS = new int[]{80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    private static final int[] EQUALS = new int[]{116, 115, 110, 111, 112};
    private DetailAST parentToSkip;
    private int assignDepth;

    public int[] getDefaultTokens() {
        return new int[]{28, 58, 142, 140, 137, 141, 139, 135, 134, 133, 80, 106, 108, 104, 107, 101, 99, 102, 98, 105, 103, 100};
    }

    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        boolean surrounded = UnnecessaryParenthesesExtendedCheck.isSurrounded(ast);
        DetailAST parent = ast.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (surrounded && type == 58) {
            this.parentToSkip = ast.getParent();
            this.log(ast, MSG_KEY_IDENT, new Object[]{ast.getText()});
            return;
        }
        if (surrounded && UnnecessaryParenthesesExtendedCheck.inTokenList(type, LITERALS)) {
            this.parentToSkip = ast.getParent();
            if (type == 139) {
                this.log(ast, MSG_KEY_STRING, new Object[]{UnnecessaryParenthesesExtendedCheck.chopString(ast.getText())});
            } else {
                this.log(ast, MSG_KEY_LITERAL, new Object[]{ast.getText()});
            }
            return;
        }
        if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
            ++this.assignDepth;
            DetailAST last = ast.getLastChild();
            if (last.getType() == 77) {
                DetailAST subtree = ast.getFirstChild().getNextSibling().getNextSibling();
                int subtreeType = subtree.getType();
                if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(subtreeType, EQUALS)) {
                    this.log(ast, MSG_KEY_ASSIGN, new Object[0]);
                }
            }
        }
    }

    public void leaveToken(DetailAST ast) {
        int type = ast.getType();
        DetailAST parent = ast.getParent();
        if (type == 80 && parent.getType() == 160) {
            return;
        }
        if (type == 28) {
            if (this.parentToSkip != ast && UnnecessaryParenthesesExtendedCheck.exprSurrounded(ast)) {
                if (this.assignDepth >= 1) {
                    if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                        this.log(ast, MSG_KEY_ASSIGN, new Object[0]);
                    }
                } else if (ast.getParent().getType() == 88) {
                    if (!this.ignoreCalculationOfBooleanVariablesWithReturn || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                        this.log(ast, MSG_KEY_RETURN, new Object[0]);
                    }
                } else if (ast.getParent().getType() == 151) {
                    if (!this.ignoreCalculationOfBooleanVariablesWithAssert || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                        this.log(ast, MSG_KEY_EXPR, new Object[0]);
                    }
                } else if (!this.ignoreCalculationOfBooleanVariables || !UnnecessaryParenthesesExtendedCheck.inTokenList(UnnecessaryParenthesesExtendedCheck.subtreeType(ast), EQUALS)) {
                    this.log(ast, MSG_KEY_EXPR, new Object[0]);
                }
            }
            this.parentToSkip = null;
        } else if (UnnecessaryParenthesesExtendedCheck.inTokenList(type, ASSIGNMENTS)) {
            --this.assignDepth;
        }
        super.leaveToken(ast);
    }

    private static boolean isSurrounded(DetailAST ast) {
        DetailAST prev = ast.getPreviousSibling();
        DetailAST next = ast.getNextSibling();
        return prev != null && prev.getType() == 76 && next != null && next.getType() == 77;
    }

    private static boolean exprSurrounded(DetailAST ast) {
        boolean surrounded = false;
        if (ast.getChildCount() >= 3) {
            DetailAST n1 = ast.getFirstChild();
            DetailAST nn = ast.getLastChild();
            surrounded = n1.getType() == 76 && nn.getType() == 77;
        }
        return surrounded;
    }

    private static boolean inTokenList(int type, int[] tokens) {
        boolean found = false;
        for (int i = 0; i < tokens.length && !found; ++i) {
            found = tokens[i] == type;
        }
        return found;
    }

    private static String chopString(String string) {
        if (string.length() > 25) {
            return string.substring(0, 25) + "...\"";
        }
        return string;
    }

    private static int subtreeType(DetailAST ast) {
        DetailAST subtree = ast.getFirstChild().getNextSibling();
        return subtree.getType();
    }

    public final void setIgnoreCalculationOfBooleanVariables(boolean ignoreCalculationOfBooleanVariables) {
        this.ignoreCalculationOfBooleanVariables = ignoreCalculationOfBooleanVariables;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithReturn(boolean ignoreCalculationOfBooleanVariablesWithReturn) {
        this.ignoreCalculationOfBooleanVariablesWithReturn = ignoreCalculationOfBooleanVariablesWithReturn;
    }

    public final void setIgnoreCalculationOfBooleanVariablesWithAssert(boolean ignoreCalculationOfBooleanVariablesWithAssert) {
        this.ignoreCalculationOfBooleanVariablesWithAssert = ignoreCalculationOfBooleanVariablesWithAssert;
    }
}

