/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.cloudfoundry.client.diego;

import java.io.IOException;
import java.net.URI;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.RestTemplate;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.AuthorizationHeaderProvider;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.CloudInfoV2;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.RestUtils;

public abstract class CfClientSideCart {
    protected final AuthorizationHeaderProvider oauth;
    protected final RestTemplate restTemplate;
    protected final CloudInfoV2 cloudInfo;
    protected final CloudFoundryOperations client;

    public CfClientSideCart(CloudFoundryOperations client, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        this.cloudInfo = cloudInfo;
        this.client = client;
        this.oauth = this.authProvider(client);
        this.restTemplate = RestUtils.createRestTemplate(httpProxyConfiguration, trustSelfSigned, true);
        ClientHttpRequestFactory requestFactory = this.restTemplate.getRequestFactory();
        this.restTemplate.setRequestFactory(this.authorize(requestFactory));
    }

    private AuthorizationHeaderProvider authProvider(final CloudFoundryOperations client) {
        return new AuthorizationHeaderProvider(){

            @Override
            public String getAuthorizationHeader() {
                OAuth2AccessToken token = client.login();
                return String.valueOf(token.getTokenType()) + " " + token.getValue();
            }
        };
    }

    protected ClientHttpRequestFactory authorize(final ClientHttpRequestFactory delegate) {
        return new ClientHttpRequestFactory(){

            public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
                ClientHttpRequest request = delegate.createRequest(uri, httpMethod);
                request.getHeaders().add("Authorization", CfClientSideCart.this.oauth.getAuthorizationHeader());
                return request;
            }
        };
    }

    protected String url(String path) {
        return String.valueOf(this.cloudInfo.getCloudControllerUrl()) + path;
    }
}

