/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.cloudfoundry.client.diego;

import java.net.URL;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.springframework.web.client.RestTemplate;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.RestUtils;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.SshHost;

public class CloudInfoV2 {
    private RestTemplate restTemplate;
    private URL ccUrl;
    private Map<String, Object> infoV2Map;

    public CloudInfoV2(CloudCredentials creds, URL url, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        this.restTemplate = RestUtils.createRestTemplate(proxyConf, selfSigned, false);
        this.ccUrl = url;
    }

    public String getSshClientId() {
        return this.getProp("app_ssh_oauth_client");
    }

    public String getAuthorizationUrl() {
        return this.getProp("authorization_endpoint");
    }

    public String getCloudControllerUrl() {
        return this.ccUrl.toString();
    }

    public String getProp(String name) {
        Map<String, Object> map = this.getMap();
        if (map != null) {
            return (String)CloudUtil.parse(String.class, (Object)map.get(name));
        }
        return null;
    }

    private Map<String, Object> getMap() {
        if (this.infoV2Map == null) {
            String infoV2Json = (String)this.restTemplate.getForObject(this.getUrl("/v2/info"), String.class, new Object[0]);
            this.infoV2Map = JsonUtil.convertJsonToMap((String)infoV2Json);
        }
        return this.infoV2Map;
    }

    private String getUrl(String path) {
        return this.ccUrl + path;
    }

    public SshHost getSshHost() {
        String fingerPrint = this.getProp("app_ssh_host_key_fingerprint");
        String host = this.getProp("app_ssh_endpoint");
        int port = 22;
        if (host != null && host.contains(":")) {
            String[] pieces = host.split(":");
            host = pieces[0];
            port = Integer.parseInt(pieces[1]);
        }
        if (host != null) {
            return new SshHost(host, port, fingerPrint);
        }
        return null;
    }
}

