/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.cloudfoundry.client.diego;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.springframework.web.client.RestTemplate;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.CfClientSideCart;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.CloudInfoV2;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.RestUtils;

public class HealthCheckSupport
extends CfClientSideCart {
    public static final String HC_NONE = "none";
    public static final String HC_PORT = "port";
    public static final String[] HC_ALL = new String[]{"none", "port"};

    public HealthCheckSupport(CloudFoundryOperations client, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        super(client, cloudInfo, trustSelfSigned, httpProxyConfiguration);
    }

    protected RestTemplate createRestTemplate(boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        return RestUtils.createRestTemplate(httpProxyConfiguration, trustSelfSigned, false);
    }

    public String getHealthCheck(UUID guid) {
        HealthCheck summary = (HealthCheck)this.restTemplate.getForObject(this.url("/v2/apps/{guid}/summary"), HealthCheck.class, new Object[]{guid});
        if (summary != null) {
            return summary.getHealthCheckType();
        }
        return null;
    }

    public String getHealthCheck(CloudApplication app) {
        return this.getHealthCheck(app.getMeta().getGuid());
    }

    public void setHealthCheck(UUID guid, String type) {
        this.restTemplate.put(this.url("/v2/apps/{guid}"), (Object)new HealthCheck(type), new Object[]{guid});
    }

    public void setHealthCheck(CloudApplication app, String type) {
        this.setHealthCheck(app.getMeta().getGuid(), type);
    }

    public static HealthCheckSupport create(CloudFoundryOperations client, CloudCredentials creds, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        CloudInfoV2 cloudInfo = new CloudInfoV2(creds, client.getCloudControllerUrl(), proxyConf, selfSigned);
        return new HealthCheckSupport(client, cloudInfo, selfSigned, proxyConf);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class HealthCheck {
        @JsonProperty(value="health_check_type")
        private String healthCheckType;

        public HealthCheck() {
        }

        public HealthCheck(String type) {
            this.healthCheckType = type;
        }

        public String getHealthCheckType() {
            return this.healthCheckType;
        }

        public void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }
    }
}

