/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.cloudfoundry.client.diego;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import javax.naming.OperationNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.CfClientSideCart;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.CloudInfoV2;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.SshClientSupport;
import org.springsource.ide.eclipse.commons.cloudfoundry.client.diego.SshHost;

public class SshClientSupportV1
extends CfClientSideCart
implements SshClientSupport {
    private String authorizationUrl;
    private String sshClientId;

    public SshClientSupportV1(CloudFoundryOperations client, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        super(client, cloudInfo, trustSelfSigned, httpProxyConfiguration);
        this.authorizationUrl = cloudInfo.getAuthorizationUrl();
        this.sshClientId = cloudInfo.getSshClientId();
    }

    @Override
    public String getSshCode() {
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(this.authorizationUrl) + "/oauth/authorize");
            builder.addParameter("response_type", "code");
            builder.addParameter("grant_type", "authorization_code");
            builder.addParameter("client_id", this.sshClientId);
            URI url = new URI(builder.toString());
            ResponseEntity response = this.restTemplate.getForEntity(url, String.class);
            HttpStatus statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.FOUND) {
                throw new CloudFoundryException(statusCode);
            }
            String loc = response.getHeaders().getFirst("Location");
            if (loc == null) {
                throw new CloudOperationException("No 'Location' header in redirect response");
            }
            List qparams = URLEncodedUtils.parse((URI)new URI(loc), (String)"utf8");
            for (NameValuePair pair : qparams) {
                String name = pair.getName();
                if (!name.equals("code")) continue;
                return pair.getValue();
            }
            throw new CloudOperationException("No 'code' param in redirect Location: " + loc);
        }
        catch (URISyntaxException e) {
            throw new CloudOperationException((Throwable)e);
        }
    }

    @Override
    public SshHost getSshHost() {
        return this.cloudInfo.getSshHost();
    }

    public static SshClientSupportV1 create(CloudFoundryOperations client, CloudCredentials creds, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        CloudInfoV2 cloudInfo = new CloudInfoV2(creds, client.getCloudControllerUrl(), proxyConf, selfSigned);
        return new SshClientSupportV1(client, cloudInfo, selfSigned, proxyConf);
    }

    @Override
    public String getSshUser(UUID appGuid, int instance) {
        return "cf:" + appGuid + "/" + instance;
    }

    @Override
    public String getSshUser(String appName, int instance) throws Exception {
        throw new OperationNotSupportedException("Not supported in CF V1 client");
    }
}

