/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.metadata.core.BeanMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.ConfigurationAnnotationMetadata;

public class ConfigurationClassAnnotationMetadataProvider
implements IAnnotationBeanMetadataProvider {
    private static final String CONFIGURATION_ANNOTATION_CLASS = Configuration.class.getName();
    private static final String[] BEAN_ANNOTATION_CLASSES = new String[]{Bean.class.getName()};

    public Set<IBeanMetadata> provideBeanMetadata(IBean bean, IType type, IAnnotationMetadata visitor) {
        LinkedHashSet<IBeanMetadata> beanMetaDataSet = new LinkedHashSet<IBeanMetadata>();
        try {
            if (visitor.hasTypeLevelAnnotations(new String[]{CONFIGURATION_ANNOTATION_CLASS})) {
                HashSet<IMethodMetadata> methodMetaData = new HashSet<IMethodMetadata>();
                for (Map.Entry entry : visitor.getMethodLevelAnnotations(BEAN_ANNOTATION_CLASSES).entrySet()) {
                    methodMetaData.add((IMethodMetadata)new BeanMethodAnnotationMetadata(((Annotation)entry.getValue()).getAnnotationClass(), ((IMethod)entry.getKey()).getHandleIdentifier(), ((Annotation)entry.getValue()).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)entry.getKey())));
                }
                beanMetaDataSet.add((IBeanMetadata)new ConfigurationAnnotationMetadata(bean, CONFIGURATION_ANNOTATION_CLASS, visitor.hasTypeLevelAnnotations(new String[]{CONFIGURATION_ANNOTATION_CLASS}) ? visitor.getTypeLevelAnnotation(CONFIGURATION_ANNOTATION_CLASS).getMembers() : null, (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)type), methodMetaData));
            }
        }
        catch (JavaModelException javaModelException) {}
        return beanMetaDataSet;
    }
}

