/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.Set;
import org.springframework.ide.eclipse.beans.core.metadata.model.AbstractAnnotationMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;

public class RequestMappingAnnotationMetadata
extends AbstractAnnotationMetadata {
    private static final long serialVersionUID = 6978657032146327628L;
    private String classHandle = null;

    public RequestMappingAnnotationMetadata(IBean bean, String handle, Object value, IModelSourceLocation location, Set<IMethodMetadata> methodMetaData, String classHandle) {
        super(bean, handle, value, location, methodMetaData);
        this.classHandle = classHandle;
    }

    public String getClassHandle() {
        return this.classHandle;
    }

    public String getValueAsText() {
        if (this.getValue() instanceof Set) {
            StringBuilder buf = new StringBuilder();
            for (AnnotationMemberValuePair pair : (Set)this.getValue()) {
                if (pair.getName() != null) {
                    buf.append(pair.getName());
                    buf.append(" = ");
                }
                buf.append(pair.getValue().toString());
                buf.append(", ");
            }
            if (buf.length() > 0) {
                return String.valueOf(buf.substring(0, buf.length() - 2)) + " -> ";
            }
            return "";
        }
        return "";
    }
}

