/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.ui;

import java.util.LinkedHashSet;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.metadata.core.RequestMappingAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.RequestMappingMethodAnnotationMetadata;
import org.springframework.util.ObjectUtils;

public class RequestMappingBeanMetadataReference
extends BeanMetadataReference {
    public RequestMappingBeanMetadataReference(IBeansProject project, String key) {
        super(project, key);
    }

    public Object[] getChildren() {
        Object[] children;
        LinkedHashSet<BeanMetadataNode> nodes = new LinkedHashSet<BeanMetadataNode>();
        Object[] objectArray = children = super.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof RequestMappingAnnotationMetadata) {
                LinkedHashSet<BeanMetadataNode> childNodes = nodes;
                BeanMetadataNode parent = null;
                RequestMappingAnnotationMetadata metadata = (RequestMappingAnnotationMetadata)((Object)child);
                if (metadata.getValue() != null) {
                    parent = new BeanMetadataNode(metadata.getHandleIdentifier());
                    IType type = (IType)JavaCore.create((String)metadata.getClassHandle());
                    parent.setLabel(String.valueOf(metadata.getValueAsText()) + BeansUIPlugin.getLabelProvider().getText((Object)type));
                    parent.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)type));
                    parent.setLocation(metadata.getElementSourceLocation());
                    nodes.add(parent);
                    childNodes = new LinkedHashSet();
                }
                for (IMethodMetadata mmd : metadata.getMethodMetaData()) {
                    RequestMappingMethodAnnotationMetadata requestMapping = (RequestMappingMethodAnnotationMetadata)mmd;
                    IMethod method = (IMethod)JdtUtils.getByHandle((String)requestMapping.getMethodHandle());
                    BeanMetadataNode node = new BeanMetadataNode(requestMapping.getMethodHandle());
                    node.setLabel(String.valueOf(requestMapping.getValueAsText()) + BeansUIPlugin.getLabelProvider().getText((Object)method.getDeclaringType()) + "." + BeansUIPlugin.getLabelProvider().getText((Object)method));
                    node.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)method));
                    node.setLocation(requestMapping.getElementSourceLocation());
                    childNodes.add(node);
                }
                if (parent != null) {
                    parent.setChildren(childNodes.toArray());
                }
            }
            ++n2;
        }
        return nodes.toArray();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingBeanMetadataReference)) {
            return false;
        }
        RequestMappingBeanMetadataReference that = (RequestMappingBeanMetadataReference)((Object)other);
        return ObjectUtils.nullSafeEquals((Object)this.beansProject, (Object)that.beansProject);
    }

    public int hashCode() {
        return 33 * this.beansProject.hashCode();
    }
}

