/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springsource.ide.eclipse.commons.core.Policy;
import org.springsource.ide.eclipse.commons.core.process.StandardProcessRunner;
import org.springsource.ide.eclipse.commons.core.util.OsUtils;

public class ZipFileUtil {
    private static final int BUFFER_SIZE = 524288;

    public static void unzip(URL source, File targetFile, IProgressMonitor monitor) throws IOException {
        ZipFileUtil.unzip(source, targetFile, null, monitor);
    }

    public static void unzip(URL source, File targetFile, String prefix, IProgressMonitor monitor) throws IOException {
        ZipFileUtil.unzip(source, targetFile, prefix, PermissionSetter.NULL, monitor);
    }

    public static void unzip(URL source, File targetFile, String prefix, PermissionSetter permsetter, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Extracting " + source.getFile(), -1);
            byte[] buffer = new byte[524288];
            try (ZipInputStream zipIn = new ZipInputStream(source.openStream());){
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (prefix != null && name.startsWith(prefix) && (name = name.substring(prefix.length())).length() > 1) {
                        name = name.substring(1);
                    }
                    Policy.checkCancelled(monitor);
                    monitor.subTask(name);
                    if (entry.isDirectory()) {
                        new File(targetFile, name).mkdirs();
                        continue;
                    }
                    File entryFile = new File(targetFile, name);
                    entryFile.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(entryFile);){
                        int len;
                        while ((len = zipIn.read(buffer)) >= 0) {
                            Policy.checkCancelled(monitor);
                            out.write(buffer, 0, len);
                        }
                    }
                    long modTime = entry.getTime();
                    if (modTime > 0L) {
                        entryFile.setLastModified(modTime);
                    }
                    permsetter.fileUnzipped(entry, entryFile);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void unzip(File zipFile, File unzipDir, IProgressMonitor monitor) throws MalformedURLException, IOException {
        ZipFileUtil.unzip(zipFile.toURI().toURL(), unzipDir, monitor);
    }

    public static abstract class PermissionSetter {
        public static final PermissionSetter NULL = new PermissionSetter(){

            @Override
            public void fileUnzipped(ZipEntry entry, File entryFile) {
            }
        };

        public abstract void fileUnzipped(ZipEntry var1, File var2) throws IOException;

        public static PermissionSetter executableExtensions(final String ... exts) {
            if (OsUtils.isWindows()) {
                return NULL;
            }
            return new PermissionSetter(){

                @Override
                public void fileUnzipped(ZipEntry entry, File entryFile) throws IOException {
                    String[] stringArray = exts;
                    int n = exts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ext = stringArray[n2];
                        if (entryFile.getName().endsWith(ext)) {
                            StandardProcessRunner runner = new StandardProcessRunner();
                            try {
                                runner.run(new File("."), "chmod", "a+x", entryFile.toString());
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
    }
}

