/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.util;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class NatureUtils {
    public static void ensure(IProject project, IProgressMonitor mon, String ... reqNatures) throws CoreException {
        String n;
        IProjectDescription desc = project.getDescription();
        String[] oldNaturesArr = desc.getNatureIds();
        LinkedHashSet<String> natures = new LinkedHashSet<String>();
        String[] stringArray = reqNatures;
        int n2 = reqNatures.length;
        int n3 = 0;
        while (n3 < n2) {
            n = stringArray[n3];
            natures.add(n);
            ++n3;
        }
        stringArray = oldNaturesArr;
        n2 = oldNaturesArr.length;
        n3 = 0;
        while (n3 < n2) {
            n = stringArray[n3];
            natures.add(n);
            ++n3;
        }
        if (natures.size() > oldNaturesArr.length) {
            desc.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(desc, mon);
        } else {
            desc.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(desc, 64, mon);
        }
    }

    public static void remove(IProject project, String natureId, IProgressMonitor mon) throws CoreException {
        IProjectDescription desc = project.getDescription();
        String[] oldNaturesArr = desc.getNatureIds();
        LinkedHashSet<String> natures = new LinkedHashSet<String>();
        String[] stringArray = oldNaturesArr;
        int n = oldNaturesArr.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (!n3.equals(natureId)) {
                natures.add(n3);
            }
            ++n2;
        }
        if (natures.size() != oldNaturesArr.length) {
            desc.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(desc, mon);
        }
    }

    public static boolean hasNature(IProject p, String natureId) {
        try {
            return p != null && p.isAccessible() && p.hasNature(natureId);
        }
        catch (CoreException e) {
            CorePlugin.log(e);
            return false;
        }
    }
}

