/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.discovery.ui.DiscoveryUi;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.core.HttpUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.CachedFeedsManager;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.FeedsReader;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.UpdateNotification;
import org.springsource.ide.eclipse.dashboard.internal.ui.util.IdeUiUtils;

public class AggregateFeedJob
extends Job {
    public static final Object CONTENT_FAMILY = new Object();
    private final Map<String, String> feedsToIconsMap;
    private final CachedFeedsManager feedManager;
    private final FeedsReader feedReader;
    private String feedName;
    private List<UpdateNotification> notifications = new ArrayList<UpdateNotification>();

    public AggregateFeedJob(Map<String, String> feedsToIconsMap, String feedName) {
        this("Downloading RSS feeds", feedsToIconsMap, feedName);
    }

    public AggregateFeedJob(String name, Map<String, String> feedsToIconsMap, String feedName) {
        super(name);
        this.feedsToIconsMap = feedsToIconsMap;
        this.feedName = feedName;
        this.feedReader = new FeedsReader();
        this.feedManager = new CachedFeedsManager(feedName, feedsToIconsMap, this.feedReader);
        this.setProperty(IProgressConstants.ICON_PROPERTY, StsUiImages.RSS);
    }

    public boolean belongsTo(Object family) {
        return CONTENT_FAMILY == family;
    }

    public FeedsReader getFeedReader() {
        return this.feedReader;
    }

    public boolean isCoveredBy(AggregateFeedJob other) {
        if (other.feedsToIconsMap != null && this.feedsToIconsMap != null) {
            return other.feedsToIconsMap.equals(this.feedsToIconsMap);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(final IProgressMonitor monitor) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            Job[] buildJobs;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Job[] jobArray = buildJobs = Job.getJobManager().find(CONTENT_FAMILY);
            int n = buildJobs.length;
            int n2 = 0;
            while (n2 < n) {
                AggregateFeedJob job;
                Job curr = jobArray[n2];
                if (curr != this && curr instanceof AggregateFeedJob && (job = (AggregateFeedJob)curr).isCoveredBy(this)) {
                    curr.cancel();
                }
                ++n2;
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        final CountDownLatch resultLatch = new CountDownLatch(1);
        Runnable downloadRunnable = new Runnable(){

            @Override
            public void run() {
                SyndFeedInput input = new SyndFeedInput();
                HashMap<String, String> feedToContent = new HashMap<String, String>();
                try {
                    Set entrySet = AggregateFeedJob.this.feedsToIconsMap.entrySet();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)entrySet.size());
                    if (!entrySet.isEmpty()) {
                        for (Map.Entry entry : entrySet) {
                            XmlReader reader;
                            String feedUrlStr = (String)entry.getKey();
                            String iconPath = (String)entry.getValue();
                            if (feedUrlStr.startsWith("http")) {
                                reader = new XmlReader(HttpUtil.stream((URI)new URI(feedUrlStr), (IProgressMonitor)progress.newChild(1)));
                            } else {
                                InputStream stream = FileLocator.openStream((Bundle)IdeUiPlugin.getDefault().getBundle(), (IPath)new Path(feedUrlStr), (boolean)false);
                                reader = new XmlReader(stream);
                            }
                            StringBuilder cachedFeed = new StringBuilder();
                            char[] buffer = new char[256];
                            int length = 0;
                            while ((length = reader.read(buffer)) > 0) {
                                cachedFeed.append(buffer, 0, length);
                            }
                            reader.close();
                            AggregateFeedJob.this.feedReader.readFeeds(new StringReader(cachedFeed.toString()), input, iconPath);
                            feedToContent.put(feedUrlStr, cachedFeed.toString());
                        }
                    }
                    AggregateFeedJob.this.feedManager.cacheFeeds(feedToContent);
                }
                catch (Exception exception) {}
                resultLatch.countDown();
            }
        };
        try {
            new Thread(downloadRunnable).start();
            if (resultLatch.await(30L, TimeUnit.SECONDS)) {
                this.updateNotifications(monitor);
                return Status.OK_STATUS;
            }
            try {
                this.feedManager.readCachedFeeds(monitor);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "An unexpected error occurred while retrieving feed content from cache.", (Throwable)e));
            }
        }
        catch (InterruptedException interruptedException) {}
        this.updateNotifications(monitor);
        return Status.CANCEL_STATUS;
    }

    private void updateNotifications(IProgressMonitor monitor) {
        Map<SyndEntry, SyndFeed> entryToFeed = this.getFeedReader().getFeedsWithEntries();
        Set<SyndEntry> entries = entryToFeed.keySet();
        Set installedFeatures = null;
        try {
            installedFeatures = DiscoveryUi.createInstallJob().getInstalledFeatures(monitor);
        }
        catch (NullPointerException nullPointerException) {}
        Hashtable<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
        ArrayList<SyndEntry> sortedEntries = new ArrayList<SyndEntry>(entries);
        Collections.sort(sortedEntries, new Comparator<SyndEntry>(){

            @Override
            public int compare(SyndEntry o1, SyndEntry o2) {
                Date o2Date;
                Date o1Date = o1.getPublishedDate() != null ? o1.getPublishedDate() : o1.getUpdatedDate();
                Date date = o2Date = o2.getPublishedDate() != null ? o2.getPublishedDate() : o2.getUpdatedDate();
                if (o1Date == null && o2Date == null) {
                    return 0;
                }
                if (o1Date == null) {
                    return -1;
                }
                if (o2Date == null) {
                    return 1;
                }
                return o2Date.compareTo(o1Date);
            }
        });
        Version ideVersion = IdeUiUtils.getVersion();
        HashSet<UpdateNotification> notificationsSet = new HashSet<UpdateNotification>(this.notifications);
        for (SyndEntry entry : sortedEntries) {
            UpdateNotification notification = new UpdateNotification(entry);
            if (!notification.matches(ideVersion, installedFeatures, environment)) continue;
            notificationsSet.add(notification);
        }
        this.notifications = new ArrayList<UpdateNotification>(notificationsSet);
    }

    public List<UpdateNotification> getNotifications() {
        return this.notifications;
    }

    public String getFeedName() {
        return this.feedName;
    }
}

