/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.AbstractFormPage;

public class StsTaskEditorActionContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private SubActionBars sourceActionBars;
    private FormEditor editor;
    private final GlobalAction cutAction = new GlobalAction(ActionFactory.CUT.getId());
    private final GlobalAction undoAction;
    private final GlobalAction redoAction;
    private final GlobalAction copyAction;
    private final GlobalAction pasteAction;
    private final GlobalAction selectAllAction;

    public StsTaskEditorActionContributor() {
        this.cutAction.setText(WorkbenchMessages.Workbench_cut);
        this.cutAction.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
        this.cutAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_CUT_DISABLED"));
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.pasteAction = new GlobalAction(ActionFactory.PASTE.getId());
        this.pasteAction.setText(WorkbenchMessages.Workbench_paste);
        this.pasteAction.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
        this.pasteAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new GlobalAction(ActionFactory.COPY.getId());
        this.copyAction.setText(WorkbenchMessages.Workbench_copy);
        this.copyAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.undoAction = new GlobalAction(ActionFactory.UNDO.getId());
        this.undoAction.setText(WorkbenchMessages.Workbench_undo);
        this.undoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO"));
        this.undoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_UNDO_DISABLED"));
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new GlobalAction(ActionFactory.REDO.getId());
        this.redoAction.setText(WorkbenchMessages.Workbench_redo);
        this.redoAction.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.redoAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO_DISABLED"));
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.selectAllAction = new GlobalAction(ActionFactory.SELECT_ALL.getId());
        this.selectAllAction.setText(WorkbenchMessages.Workbench_selectAll);
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.selectAllAction.setEnabled(true);
    }

    public void addClipboardActions(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IContributionItem)new Separator());
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        boolean addClipboard = this.getEditor().getActivePageInstance() != null && this.getEditor().getActivePageInstance() instanceof AbstractFormPage;
        this.contextMenuAboutToShow(mng, addClipboard);
    }

    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.getEditorSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(manager);
        }
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void dispose() {
        this.sourceActionBars.dispose();
        super.dispose();
    }

    public void forceActionsEnabled() {
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.selectAllAction.setEnabled(true);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public ISelection getEditorSelection() {
        if (this.editor != null && this.editor.getSite().getSelectionProvider() != null) {
            return this.editor.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.sourceActionBars = new SubActionBars(bars);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.registerGlobalHandlers(bars);
    }

    public void registerGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.updateActionBars();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelectableActions(event.getSelection());
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof FormEditor) {
            this.editor = (FormEditor)targetEditor;
            this.updateSelectableActions(this.getEditorSelection());
        }
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.getEditor() != null) {
            this.updateSelectableActions(this.getEditorSelection());
        }
    }

    public void unregisterGlobalHandlers(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
        bars.updateActionBars();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            this.undoAction.selectionChanged(selection);
            this.redoAction.selectionChanged(selection);
            this.selectAllAction.selectionChanged(selection);
        }
    }

    private class GlobalAction
    extends Action {
        private final String actionId;

        public GlobalAction(String actionId) {
            this.actionId = actionId;
        }

        public void run() {
            if (StsTaskEditorActionContributor.this.getEditor().getActivePageInstance() instanceof AbstractFormPage) {
                AbstractFormPage page = (AbstractFormPage)StsTaskEditorActionContributor.this.getEditor().getActivePageInstance();
                page.doAction(this.actionId);
                StsTaskEditorActionContributor.this.updateSelectableActions(StsTaskEditorActionContributor.this.getEditorSelection());
            }
        }

        public void selectionChanged(ISelection selection) {
            if (StsTaskEditorActionContributor.this.getEditor().getActivePageInstance() instanceof AbstractFormPage) {
                AbstractFormPage page = (AbstractFormPage)StsTaskEditorActionContributor.this.getEditor().getActivePageInstance();
                this.setEnabled(page.canPerformAction(this.actionId));
            }
        }
    }
}

