/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;

public class BootWizardImages {
    private static final String WIZBAN = "wizban";
    private static ImageRegistry imageRegistry;
    private static URL baseURL;
    public static final ImageDescriptor BOOT_WIZARD_ICON;
    public static final ImageDescriptor GUIDES_WIZARD_ICON;

    static {
        baseURL = null;
        BOOT_WIZARD_ICON = BootWizardImages.create(WIZBAN, "boot_wizard.png");
        GUIDES_WIZARD_ICON = BootWizardImages.create(WIZBAN, "guides_wizard.png");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BootWizardImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = BootWizardImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static void initBaseURL() {
        if (baseURL == null) {
            baseURL = BootWizardActivator.getDefault().getBundle().getEntry("/icons/full/");
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        BootWizardImages.initBaseURL();
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append("/");
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

