/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class CheckBoxesSection<T>
extends WizardPageSection {
    private List<CheckBoxModel<T>> model;
    private Composite composite;
    private WizardPageSection[] subsections;
    private int numCols;
    private String label;

    public CheckBoxesSection(IPageWithSections owner, List<CheckBoxModel<T>> model, String label) {
        super(owner);
        this.label = label;
        this.model = model;
    }

    public CheckBoxesSection(IPageWithSections owner, List<CheckBoxModel<T>> model) {
        this(owner, model, null);
    }

    public CheckBoxesSection<T> columns(int howMany) {
        Assert.isLegal((howMany > 0 ? 1 : 0) != 0);
        this.numCols = howMany;
        return this;
    }

    protected GridLayout createLayout() {
        return new GridLayout(this.numCols, true);
    }

    public void createContents(Composite page) {
        this.composite = this.createComposite(page);
        GridLayout layout = this.createLayout();
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.composite);
        this.createSubsections();
    }

    private void createSubsections() {
        this.subsections = new WizardPageSection[Math.max(1, this.model.size())];
        if (this.model.isEmpty()) {
            this.subsections[0] = new CommentSection(this.owner, "No choices available");
            this.subsections[0].createContents(this.composite);
        }
        int i = 0;
        while (i < this.model.size()) {
            this.subsections[i] = new CheckBox<T>(this.owner, this.model.get(i));
            this.subsections[i].createContents(this.composite);
            ++i;
        }
    }

    protected Composite createComposite(Composite page) {
        if (this.label != null) {
            Group comp = new Group(page, 0);
            comp.setText(this.label);
            return comp;
        }
        return new Composite(page, 0);
    }

    public boolean applyFilter(Filter<CheckBoxModel<T>> filter) {
        if (this.subsections != null) {
            boolean visibilityChanged = false;
            WizardPageSection[] wizardPageSectionArray = this.subsections;
            int n = this.subsections.length;
            int n2 = 0;
            while (n2 < n) {
                WizardPageSection subsection = wizardPageSectionArray[n2];
                if (subsection instanceof CheckBox) {
                    CheckBox cb = (CheckBox)subsection;
                    visibilityChanged |= cb.applyFilter(filter);
                }
                ++n2;
            }
            if (visibilityChanged) {
                this.composite.layout(true);
            }
            return visibilityChanged;
        }
        return false;
    }

    public boolean hasVisible() {
        if (this.subsections != null) {
            WizardPageSection[] wizardPageSectionArray = this.subsections;
            int n = this.subsections.length;
            int n2 = 0;
            while (n2 < n) {
                CheckBox cb;
                WizardPageSection s = wizardPageSectionArray[n2];
                if (s instanceof CheckBox && (cb = (CheckBox)s).isVisible()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    boolean isCreated() {
        return this.composite != null;
    }

    public void dispose() {
        if (this.subsections != null) {
            WizardPageSection[] wizardPageSectionArray = this.subsections;
            int n = this.subsections.length;
            int n2 = 0;
            while (n2 < n) {
                WizardPageSection subsection = wizardPageSectionArray[n2];
                subsection.dispose();
                ++n2;
            }
        }
        super.dispose();
    }

    public void setModel(List<CheckBoxModel<T>> model) {
        this.dispose();
        this.model = model;
        this.createSubsections();
        this.composite.layout();
    }

    private static class CheckBox<T>
    extends WizardPageSection {
        private Button cb;
        private CheckBoxModel<T> model;
        private LiveVariable<Boolean> isVisible = new LiveVariable((Object)true);
        private ValueListener<Boolean> selectionListener;
        private ValueListener<Boolean> enablementListener;

        public CheckBox(IPageWithSections owner, CheckBoxModel<T> model) {
            super(owner);
            this.model = model;
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.OK;
        }

        public void createContents(Composite page) {
            if (page != null && !page.isDisposed()) {
                this.cb = new Button(page, 32);
                this.cb.setText(this.model.getLabel());
                String tooltip = this.model.getTooltip();
                if (tooltip != null) {
                    this.cb.setToolTipText(tooltip);
                }
                this.selectionListener = new ValueListener<Boolean>(){

                    public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                        if (value != null) {
                            cb.setSelection(value.booleanValue());
                        }
                    }
                };
                this.model.getSelection().addListener((ValueListener)this.selectionListener);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cb);
                this.cb.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    private void handleSelection() {
                        model.getSelection().setValue((Object)cb.getSelection());
                    }
                });
                LiveExpression<Boolean> enablement = this.model.getEnablement();
                if (enablement != null) {
                    this.enablementListener = new ValueListener<Boolean>(){

                        public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                            if (value != null) {
                                cb.setEnabled(value.booleanValue());
                            }
                        }
                    };
                    enablement.addListener((ValueListener)this.enablementListener);
                }
                this.isVisible.addListener((ValueListener)new ValueListener<Boolean>(){

                    public void gotValue(LiveExpression<Boolean> exp, Boolean reveal) {
                        if (reveal != null && cb != null && !cb.isDisposed()) {
                            cb.setVisible(reveal.booleanValue());
                            GridData data = (GridData)cb.getLayoutData();
                            data.exclude = reveal == false;
                        }
                    }
                });
            }
        }

        public void dispose() {
            if (this.cb != null && !this.cb.isDisposed()) {
                this.cb.dispose();
                this.cb = null;
            }
            if (this.selectionListener != null) {
                this.model.getSelection().removeListener(this.selectionListener);
            }
            if (this.enablementListener != null) {
                this.model.getEnablement().removeListener(this.enablementListener);
            }
        }

        public boolean applyFilter(Filter<CheckBoxModel<T>> filter) {
            boolean wasVisible = (Boolean)this.isVisible.getValue();
            this.isVisible.setValue((Object)filter.accept(this.model));
            boolean changed = wasVisible ^ (Boolean)this.isVisible.getValue();
            return changed;
        }

        public boolean isVisible() {
            return (Boolean)this.isVisible.getValue();
        }

        public String toString() {
            return "CheckBox(" + this.model.getLabel() + ")";
        }
    }

    public static class CheckBoxModel<T> {
        private final String label;
        private final LiveVariable<Boolean> selection;
        private final LiveExpression<Boolean> enablement;
        private final T value;
        private String tooltip = null;

        public CheckBoxModel(String label, T value, LiveVariable<Boolean> selection, LiveExpression<Boolean> enablement) {
            this.label = label;
            this.value = value;
            this.selection = selection;
            this.enablement = enablement;
        }

        public String getLabel() {
            return this.label;
        }

        public LiveVariable<Boolean> getSelection() {
            return this.selection;
        }

        public LiveExpression<Boolean> getEnablement() {
            return this.enablement;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return "CheckBox(" + this.label + ", " + this.getSelection().getValue() + ")";
        }
    }
}

