/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.HierarchicalMultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.PreferredSelections;

public class DefaultDependencies {
    private static final String PREF_DEFAULT_DEPENDENCIES = "dependencies";
    private static final String DEPENDECIES_DELIMITER = " ";
    private String PREFIX = String.valueOf(PreferredSelections.class.getName()) + ".";
    private IPreferenceStore store;

    public DefaultDependencies(IPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.store = store;
    }

    protected String key(String id) {
        String key = String.valueOf(this.PREFIX) + id;
        return key;
    }

    private void put(String id, String value) {
        String key = this.key(id);
        this.store.setValue(key, value);
    }

    private String get(String name, String dflt) {
        String key = this.key(name);
        String v = this.store.getString(key);
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        return dflt;
    }

    public boolean save(HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> model) {
        Set<String> ids = this.getDependciesIdSet();
        CharSequence[] currentSelection = (String[])model.getCurrentSelection().stream().map(InitializrServiceSpec.Dependency::getId).toArray(String[]::new);
        if (ids.size() == currentSelection.length && ids.containsAll(Arrays.asList(currentSelection))) {
            return false;
        }
        this.put(PREF_DEFAULT_DEPENDENCIES, String.join((CharSequence)DEPENDECIES_DELIMITER, currentSelection));
        return true;
    }

    public void restore(HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> model) {
        Arrays.asList(this.get(PREF_DEFAULT_DEPENDENCIES, "").split(DEPENDECIES_DELIMITER)).forEach(id -> model.getCategories().stream().filter(category -> {
            Optional<InitializrServiceSpec.Dependency> matchedDependency = Arrays.asList((InitializrServiceSpec.Dependency[])model.getContents((String)category).getChoices()).stream().filter(dependency -> id.equals(dependency.getId())).findFirst();
            matchedDependency.ifPresent(d -> model.setSelection((String)category, (InitializrServiceSpec.Dependency)d, true));
            return matchedDependency.isPresent();
        }).findFirst());
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getDependencies(HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> model) {
        Set<String> ids = this.getDependciesIdSet();
        List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> dependencies = Collections.synchronizedList(new ArrayList(ids.size()));
        model.getCategories().parallelStream().forEach(category -> model.getContents((String)category).getCheckBoxModels().stream().filter(checkboxModel -> ids.contains(((InitializrServiceSpec.Dependency)checkboxModel.getValue()).getId())).forEach(dependencies::add));
        return dependencies;
    }

    public Set<String> getDependciesIdSet() {
        return new HashSet<String>(Arrays.asList(this.get(PREF_DEFAULT_DEPENDENCIES, "").split(DEPENDECIES_DELIMITER)));
    }
}

