/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.DependencyFilterBox;
import org.springframework.ide.eclipse.boot.wizard.EditStartersModel;
import org.springframework.ide.eclipse.boot.wizard.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.SearchBoxSection;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.DialogWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.ExpandableSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class EditStartersDialog
extends DialogWithSections {
    private static final int NUM_DEP_COLUMNS = 4;
    public EditStartersModel model;
    private DependencyFilterBox searchBoxModel;

    public EditStartersDialog(EditStartersModel model, Shell shell) {
        super("Edit Spring Boot Starters", (OkButtonHandler)model, shell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.model = model;
        this.searchBoxModel = new DependencyFilterBox();
    }

    private void applyFilter(Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> filter, ExpandableSection expandable, CheckBoxesSection<InitializrServiceSpec.Dependency> checkboxes) {
        boolean visChanged = checkboxes.applyFilter(filter);
        if (checkboxes.isCreated()) {
            boolean hasVisible = checkboxes.hasVisible();
            expandable.setVisible(hasVisible);
            if (hasVisible && visChanged) {
                expandable.getExpansionState().setValue((Object)true);
                this.reflow();
            }
        }
    }

    protected List<WizardPageSection> createSections() throws CoreException {
        ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
        List mostpopular = this.model.getFrequentlyUsedDependencies(16);
        if (!mostpopular.isEmpty()) {
            sections.add((WizardPageSection)new ExpandableSection((IPageWithSections)this, "Frequently Used", new CheckBoxesSection((IPageWithSections)this, mostpopular).columns(4)));
        }
        sections.add(new SearchBoxSection((IPageWithSections)this, this.searchBoxModel.getText()){

            @Override
            protected String getSearchHint() {
                return "Type to search dependencies";
            }
        });
        for (String cat : this.model.dependencies.getCategories()) {
            MultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencyGroup = this.model.dependencies.getContents(cat);
            final CheckBoxesSection checkboxes = new CheckBoxesSection((IPageWithSections)this, dependencyGroup.getCheckBoxModels()).columns(4);
            final ExpandableSection expandable = new ExpandableSection((IPageWithSections)this, dependencyGroup.getLabel(), checkboxes);
            sections.add((WizardPageSection)expandable);
            expandable.getExpansionState().setValue((Object)false);
            this.searchBoxModel.getFilter().addListener((ValueListener)new UIValueListener<Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>>(){

                protected void uiGotValue(LiveExpression<Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>> exp, Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> value) {
                    EditStartersDialog.this.applyFilter((Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>)value, expandable, checkboxes);
                }
            });
        }
        return sections;
    }

    public static int openFor(IProject selectedProject, Shell shell) throws Exception {
        EditStartersModel model = new EditStartersModel(selectedProject);
        String notSupported = model.getNotSupportedMessage();
        if (notSupported == null) {
            return new EditStartersDialog(model, shell).open();
        }
        MessageDialog.openError((Shell)shell, (String)"Couldn't open the 'Edit Starters' dialog", (String)notSupported);
        return 0;
    }
}

