/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.boot.core.BootPreferences;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.MavenId;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.SpringBootStarters;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.DefaultDependencies;
import org.springframework.ide.eclipse.boot.wizard.HierarchicalMultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.PopularityTracker;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class EditStartersModel
implements OkButtonHandler {
    public static final Object JOB_FAMILY = "EditStartersModel.JOB_FAMILY";
    private final ISpringBootProject project;
    private final PopularityTracker popularities;
    private final DefaultDependencies defaultDependencies;
    private final List<InitializrServiceSpec.Dependency> initialDependencies = new ArrayList<InitializrServiceSpec.Dependency>();
    public final HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies = new HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency>(InitializrServiceSpec.Dependency.class, "dependencies").label("Dependencies:");
    private HashSet<MavenId> activeStarters;
    private SpringBootStarters starters;

    public EditStartersModel(IProject selectedProject) throws Exception {
        this(selectedProject, SpringBootCore.getDefault(), BootWizardActivator.getDefault().getPreferenceStore());
    }

    public boolean isSupported() {
        String notSupportedMsg = this.getNotSupportedMessage();
        return notSupportedMsg == null;
    }

    public String getNotSupportedMessage() {
        if (this.starters == null) {
            String url = BootPreferences.getInitializrUrl();
            boolean isDefault = BootPreferences.getDefaultInitializrUrl().equals(url);
            return "Could not obtain starter dependencies information. This information is obtained by accessing the '" + url + "' webservice. " + (isDefault ? "Are you connected to the internet?" : "Initializr URL can be specified via Preferences (Spring -> Boot -> Initializr)");
        }
        return null;
    }

    public EditStartersModel(IProject selectedProject, SpringBootCore springBootCore, IPreferenceStore store) throws Exception {
        this.popularities = new PopularityTracker(store);
        this.defaultDependencies = new DefaultDependencies(store);
        this.project = springBootCore.project(selectedProject);
        this.discoverOptions(this.dependencies);
    }

    public String getBootVersion() {
        return this.starters.getBootVersion();
    }

    public String getProjectName() {
        return this.project.getProject().getName();
    }

    public void performOk() {
        Job job = new Job("Modifying starters for " + this.getProjectName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List<InitializrServiceSpec.Dependency> selected = EditStartersModel.this.dependencies.getCurrentSelection();
                    ArrayList<SpringBootStarter> selectedStarters = new ArrayList<SpringBootStarter>(selected.size());
                    for (InitializrServiceSpec.Dependency dep : selected) {
                        String id = dep.getId();
                        SpringBootStarter starter = EditStartersModel.this.starters.getStarter(id);
                        if (starter == null) continue;
                        selectedStarters.add(starter);
                    }
                    EditStartersModel.this.project.setStarters(selectedStarters);
                    for (InitializrServiceSpec.Dependency s : selected) {
                        if (EditStartersModel.this.initialDependencies.contains(s)) continue;
                        EditStartersModel.this.popularities.incrementUsageCount(s);
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return ExceptionUtil.status((Throwable)e);
                }
            }

            public boolean belongsTo(Object family) {
                return family == JOB_FAMILY;
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
    }

    private void discoverOptions(HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies) throws Exception {
        this.starters = this.project.getStarterInfos();
        Set<MavenId> activeStarters = this.getActiveStarters();
        if (this.starters != null) {
            InitializrServiceSpec.DependencyGroup[] dependencyGroupArray = this.starters.getDependencyGroups();
            int n = dependencyGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                InitializrServiceSpec.DependencyGroup dgroup = dependencyGroupArray[n2];
                String catName = dgroup.getName();
                InitializrServiceSpec.Dependency[] dependencyArray = dgroup.getContent();
                int n3 = dependencyArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InitializrServiceSpec.Dependency dep = dependencyArray[n4];
                    if (this.starters.contains(dep.getId())) {
                        dependencies.choice(catName, dep.getName(), dep, dep.getDescription(), (LiveExpression<Boolean>)LiveExpression.constant((Object)true));
                        MavenId mavenId = this.starters.getMavenId(dep.getId());
                        boolean selected = activeStarters.contains(mavenId);
                        if (selected) {
                            this.initialDependencies.add(dep);
                        }
                        dependencies.setSelection(catName, dep, selected);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private Set<MavenId> getActiveStarters() throws Exception {
        if (this.activeStarters == null) {
            this.activeStarters = new HashSet();
            List deps = this.project.getDependencies();
            if (deps != null) {
                for (IMavenCoordinates coords : deps) {
                    String gid = coords.getGroupId();
                    String aid = coords.getArtifactId();
                    if (aid == null || gid == null) continue;
                    this.activeStarters.add(new MavenId(gid, aid));
                }
            }
        }
        return this.activeStarters;
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getMostPopular(int howMany) {
        ArrayList<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> result = new ArrayList<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>();
        HashSet<InitializrServiceSpec.Dependency> seen = new HashSet<InitializrServiceSpec.Dependency>();
        for (CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> cb : this.dependencies.getAllBoxes()) {
            if (!((Boolean)cb.getSelection().getValue()).booleanValue() || !seen.add(cb.getValue())) continue;
            result.add(cb);
        }
        if (result.size() < howMany) {
            List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> popular = this.popularities.getMostPopular(this.dependencies, howMany);
            Iterator<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> iter = popular.iterator();
            while (result.size() < howMany && iter.hasNext()) {
                CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> cb = iter.next();
                if (!seen.add(cb.getValue())) continue;
                result.add(cb);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getDefaultDependencies() {
        return this.defaultDependencies.getDependencies(this.dependencies);
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getFrequentlyUsedDependencies(int numberOfMostPopular) {
        List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> dependencies = this.getDefaultDependencies();
        Set<String> defaultDependecyIds = this.defaultDependencies.getDependciesIdSet();
        this.getMostPopular(numberOfMostPopular).stream().filter(checkboxModel -> !defaultDependecyIds.contains(((InitializrServiceSpec.Dependency)checkboxModel.getValue()).getId())).forEach(dependencies::add);
        dependencies.sort(new Comparator<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>(){

            @Override
            public int compare(CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> d1, CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> d2) {
                return d1.getLabel().compareTo(d2.getLabel());
            }
        });
        return dependencies;
    }

    public void removeDependency(String dependencyId) {
        for (String catName : this.dependencies.getCategories()) {
            MultiSelectionFieldModel<InitializrServiceSpec.Dependency> cat = this.dependencies.getContents(catName);
            InitializrServiceSpec.Dependency[] dependencyArray = cat.getChoices();
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n2];
                if (dependencyId.equals(dep.getId())) {
                    cat.unselect(dep);
                    return;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("No such dependency: " + dependencyId);
    }

    public void addDependency(String dependencyId) {
        for (String catName : this.dependencies.getCategories()) {
            MultiSelectionFieldModel<InitializrServiceSpec.Dependency> cat = this.dependencies.getContents(catName);
            InitializrServiceSpec.Dependency[] dependencyArray = cat.getChoices();
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n2];
                if (dependencyId.equals(dep.getId())) {
                    cat.select(dep);
                    return;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("No such dependency: " + dependencyId);
    }
}

