/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.MultiSelectionFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public class HierarchicalMultiSelectionFieldModel<T> {
    private Map<String, MultiSelectionFieldModel<T>> categories = new TreeMap<String, MultiSelectionFieldModel<T>>();
    private String name;
    private String label;
    private Class<T> type;

    public HierarchicalMultiSelectionFieldModel(Class<T> type, String name) {
        this.name = name;
        this.label = name;
        this.type = type;
    }

    public Collection<String> getCategories() {
        return Collections.unmodifiableCollection(this.categories.keySet());
    }

    public MultiSelectionFieldModel<T> getContents(String category) {
        return this.categories.get(category);
    }

    public HierarchicalMultiSelectionFieldModel<T> label(String label) {
        this.label = label;
        return this;
    }

    private MultiSelectionFieldModel<T> ensureCategory(String categoryName) {
        MultiSelectionFieldModel<T> existing = this.categories.get(categoryName);
        if (existing == null) {
            existing = new MultiSelectionFieldModel<T>(this.type, this.name).label(categoryName);
            this.categories.put(categoryName, existing);
        }
        return existing;
    }

    public void sort() {
        for (String cat : this.getCategories()) {
            this.getContents(cat).sort();
        }
    }

    public void choice(String catName, String name, T dep, String tooltipText, LiveExpression<Boolean> enablement) {
        MultiSelectionFieldModel<T> cat = this.ensureCategory(catName);
        cat.choice(name, dep, tooltipText, enablement);
    }

    public void setSelection(String catName, T dep, boolean selected) {
        MultiSelectionFieldModel<T> cat = this.categories.get(catName);
        if (cat != null) {
            cat.getSelection(dep).setValue((Object)selected);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public List<T> getCurrentSelection() {
        ArrayList<T> selecteds = new ArrayList<T>();
        for (String cat : this.getCategories()) {
            selecteds.addAll(this.getContents(cat).getCurrentSelection());
        }
        return Collections.unmodifiableList(selecteds);
    }

    public List<CheckBoxesSection.CheckBoxModel<T>> getAllBoxes() {
        ArrayList<CheckBoxesSection.CheckBoxModel<T>> allUsedBoxes = new ArrayList<CheckBoxesSection.CheckBoxModel<T>>();
        for (String category : this.getCategories()) {
            allUsedBoxes.addAll(this.getContents(category).getCheckBoxModels());
        }
        return allUsedBoxes;
    }

    public void clearSelection() {
        this.categories.values().forEach(MultiSelectionFieldModel::clearSelection);
    }
}

