/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class MultiSelectionFieldModel<T> {
    private static final LiveExpression<Boolean> ALLWAYS_ENABLED = LiveExpression.constant((Object)true);
    private Class<T> type;
    private String name;
    private String label;
    private LiveExpression<ValidationResult> validator;
    private Map<T, String> labelMap = new LinkedHashMap<T, String>();
    private Map<T, String> tooltips = null;
    private boolean mustSort;
    private Map<T, LiveExpression<Boolean>> enablements = null;
    private Map<T, LiveVariable<Boolean>> selections = new HashMap<T, LiveVariable<Boolean>>();

    public MultiSelectionFieldModel(Class<T> type, String name) {
        this.type = type;
        this.name = name;
        this.label = name;
        this.validator = Validator.OK;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabel(T value) {
        return this.labelMap.get(value);
    }

    public String getName() {
        return this.name;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    public MultiSelectionFieldModel<T> validator(LiveExpression<ValidationResult> v) {
        this.validator = v;
        return this;
    }

    public void select(T v) {
        this.getSelection(v).setValue((Object)true);
    }

    public synchronized LiveVariable<Boolean> getSelection(T v) {
        LiveVariable existing = this.selections.get(v);
        if (existing == null) {
            existing = new LiveVariable((Object)false);
            this.selections.put(v, (LiveVariable<Boolean>)existing);
        }
        return existing;
    }

    public void unselect(T v) {
        this.getSelection(v).setValue((Object)false);
    }

    public MultiSelectionFieldModel<T> choice(String label, T value) {
        Assert.isLegal((this.labelMap.get(value) == null ? 1 : 0) != 0, (String)("Duplicate choice " + value + " already added"));
        this.labelMap.put(value, label);
        return this;
    }

    public void choice(String label, T value, String tooltipText) {
        this.choice(label, value);
        this.setTooltip(value, tooltipText);
    }

    public void choice(String label, T value, String tooltipText, LiveExpression<Boolean> enablement) {
        this.choice(label, value, tooltipText);
        if (this.enablements == null) {
            this.enablements = new HashMap<T, LiveExpression<Boolean>>();
        }
        this.enablements.put(value, enablement);
    }

    public void setTooltip(T value, String tooltipText) {
        if (this.tooltips == null) {
            this.tooltips = new HashMap<T, String>();
        }
        this.tooltips.put(value, tooltipText);
    }

    public String getTooltip(T value) {
        if (this.tooltips != null) {
            return this.tooltips.get(value);
        }
        return null;
    }

    public MultiSelectionFieldModel<T> label(String label) {
        this.label = label;
        return this;
    }

    public synchronized T[] getChoices() {
        Set<Object> values = this.labelMap.keySet();
        Object[] choices = values.toArray((Object[])Array.newInstance(this.getType(), values.size()));
        if (this.mustSort) {
            Arrays.sort(choices, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    String s1 = MultiSelectionFieldModel.this.getLabel(o1);
                    String s2 = MultiSelectionFieldModel.this.getLabel(o2);
                    return s1.compareTo(s2);
                }
            });
        }
        return choices;
    }

    public void sort() {
        this.mustSort = true;
    }

    public LiveExpression<Boolean> getEnablement(T choice) {
        LiveExpression<Boolean> e;
        if (this.enablements != null && (e = this.enablements.get(choice)) != null) {
            return e;
        }
        return ALLWAYS_ENABLED;
    }

    public synchronized List<T> getCurrentSelection() {
        ArrayList<T> selecteds = new ArrayList<T>();
        for (Map.Entry<T, LiveVariable<Boolean>> e : this.selections.entrySet()) {
            if (!((Boolean)e.getValue().getValue()).booleanValue()) continue;
            selecteds.add(e.getKey());
        }
        return Collections.unmodifiableList(selecteds);
    }

    public List<CheckBoxesSection.CheckBoxModel<T>> getCheckBoxModels() {
        ArrayList<CheckBoxesSection.CheckBoxModel<T>> checkboxes = new ArrayList<CheckBoxesSection.CheckBoxModel<T>>(this.labelMap.size());
        for (T choice : this.labelMap.keySet()) {
            CheckBoxesSection.CheckBoxModel<T> cb = new CheckBoxesSection.CheckBoxModel<T>(this.getLabel(choice), choice, this.getSelection(choice), this.getEnablement(choice));
            checkboxes.add(cb);
            cb.setTooltip(this.getTooltip(choice));
        }
        return Collections.unmodifiableList(checkboxes);
    }

    public void clearSelection() {
        this.selections.values().forEach(liveVar -> liveVar.setValue((Object)false));
    }
}

