/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.BootWizardImages;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.NewSpringBootWizardModel;
import org.springframework.ide.eclipse.boot.wizard.RadioGroup;
import org.springframework.ide.eclipse.boot.wizard.SearchBoxSection;
import org.springframework.ide.eclipse.boot.wizard.WorkingSetSection;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.ButtonSection;
import org.springsource.ide.eclipse.commons.livexp.ui.ChooseOneSectionCombo;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.DescriptionSection;
import org.springsource.ide.eclipse.commons.livexp.ui.ExpandableSection;
import org.springsource.ide.eclipse.commons.livexp.ui.GroupSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.ProjectLocationSection;
import org.springsource.ide.eclipse.commons.livexp.ui.StringFieldSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class NewSpringBootWizard
extends Wizard
implements INewWizard,
IImportWizard {
    private static final ImageDescriptor IMAGE = BootWizardImages.BOOT_WIZARD_ICON;
    private NewSpringBootWizardModel model;
    private IStructuredSelection selection;
    private WorkingSetSection workingSetSection;
    private ProjectDetailsPage projectPage;

    public NewSpringBootWizard() throws Exception {
        this.setDefaultPageImageDescriptor(IMAGE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.model = new NewSpringBootWizardModel();
            this.selection = selection;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)"Error opening the wizard", (String)(String.valueOf(ExceptionUtil.getMessage((Throwable)e)) + "\n\n" + "Note that this wizard uses a webservice and needs internet access.\n" + "A more detailed error message may be found in the Eclipse error log."));
            BootWizardActivator.log(e);
            throw new Error(e);
        }
    }

    public void addPages() {
        super.addPages();
        this.projectPage = new ProjectDetailsPage();
        this.addPage((IWizardPage)this.projectPage);
        this.addPage((IWizardPage)new DependencyPage());
        this.addPage((IWizardPage)new PageThree());
    }

    public boolean canFinish() {
        return super.canFinish() && this.getContainer().getCurrentPage() != this.projectPage;
    }

    private WizardPageSection createRadioGroupsSection(WizardPageWithSections owner) {
        boolean notEmpty = false;
        RadioGroup bootVersion = this.model.getBootVersion();
        ArrayList<ChooseOneSectionCombo> radioSections = new ArrayList<ChooseOneSectionCombo>();
        for (RadioGroup radioGroup : this.model.getRadioGroups().getGroups()) {
            if (radioGroup == bootVersion || radioGroup.getRadios().length <= 1) continue;
            radioSections.add(new ChooseOneSectionCombo((IPageWithSections)owner, radioGroup.getLabel(), radioGroup.getSelection(), (Object[])radioGroup.getRadios()));
            notEmpty = true;
        }
        if (notEmpty) {
            return new GroupSection((IPageWithSections)owner, null, radioSections.toArray(new WizardPageSection[radioSections.size()])).columns(2);
        }
        return null;
    }

    public boolean performFinish() {
        this.model.setWorkingSets(this.workingSetSection.getWorkingSets());
        Job job = new Job("Import Getting Started Content"){

            protected IStatus run(IProgressMonitor mon) {
                try {
                    NewSpringBootWizard.this.model.performFinish(mon);
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return ExceptionUtil.status((Throwable)e);
                }
            }
        };
        job.setPriority(40);
        job.setUser(true);
        job.schedule();
        return true;
    }

    public class DependencyPage
    extends WizardPageWithSections {
        private static final int NUM_DEP_COLUMNS = 4;
        private static final int MAX_MOST_POPULAR = 12;
        private ExpandableSection frequentlyUsedSection;
        private CheckBoxesSection<InitializrServiceSpec.Dependency> frequentlyUsedCheckboxes;

        protected DependencyPage() {
            super("page2", "New Spring Starter Project", null);
        }

        private void applyFilter(Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> filter, ExpandableSection expandable, CheckBoxesSection<InitializrServiceSpec.Dependency> checkboxes) {
            boolean visChanged = checkboxes.applyFilter(filter);
            if (checkboxes.isCreated()) {
                boolean hasVisible = checkboxes.hasVisible();
                expandable.setVisible(hasVisible);
                if (hasVisible && visChanged) {
                    expandable.getExpansionState().setValue((Object)true);
                    this.reflow();
                }
            }
        }

        private void refreshFrequentlyUsedDependencies() {
            List dependenciesCheckboxes = NewSpringBootWizard.this.model.getFrequentlyUsedDependencies(12);
            this.frequentlyUsedCheckboxes.setModel(dependenciesCheckboxes);
            this.frequentlyUsedSection.setVisible(!dependenciesCheckboxes.isEmpty());
            this.reflow();
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            RadioGroup bootVersion = NewSpringBootWizard.this.model.getBootVersion();
            sections.add((WizardPageSection)new ChooseOneSectionCombo((IPageWithSections)this, bootVersion.getLabel(), bootVersion.getSelection(), (Object[])bootVersion.getRadios()).useFieldLabelWidthHint(false));
            sections.add((WizardPageSection)new CommentSection((IPageWithSections)this, ((NewSpringBootWizard)NewSpringBootWizard.this).model.dependencies.getLabel()));
            List frequesntDependencies = NewSpringBootWizard.this.model.getFrequentlyUsedDependencies(12);
            this.frequentlyUsedCheckboxes = new CheckBoxesSection((IPageWithSections)this, frequesntDependencies).columns(4);
            this.frequentlyUsedSection = new ExpandableSection((IPageWithSections)this, "Frequently Used", this.frequentlyUsedCheckboxes);
            sections.add((WizardPageSection)this.frequentlyUsedSection);
            this.frequentlyUsedSection.setVisible(!frequesntDependencies.isEmpty());
            sections.add((WizardPageSection)new GroupSection((IPageWithSections)this, null, new WizardPageSection[]{new SearchBoxSection((IPageWithSections)this, NewSpringBootWizard.this.model.getDependencyFilterBoxText()){

                @Override
                protected String getSearchHint() {
                    return "Type to search dependencies";
                }
            }, new ButtonSection((IPageWithSections)this, "Make Default", () -> {
                if (NewSpringBootWizard.this.model.saveDefaultDependencies()) {
                    this.refreshFrequentlyUsedDependencies();
                }
            }).tooltip("Make currently selected dependencies selected by default"), new ButtonSection((IPageWithSections)this, "Clear Selection", () -> ((NewSpringBootWizard)NewSpringBootWizard.this).model.dependencies.clearSelection()).tooltip("Clear dependencies selection")}).columns(3, false));
            for (String cat : ((NewSpringBootWizard)NewSpringBootWizard.this).model.dependencies.getCategories()) {
                MultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencyGroup = ((NewSpringBootWizard)NewSpringBootWizard.this).model.dependencies.getContents(cat);
                final CheckBoxesSection checkboxes = new CheckBoxesSection((IPageWithSections)this, dependencyGroup.getCheckBoxModels()).columns(4);
                final ExpandableSection expandable = new ExpandableSection((IPageWithSections)this, dependencyGroup.getLabel(), checkboxes);
                sections.add((WizardPageSection)expandable);
                expandable.getExpansionState().setValue((Object)false);
                NewSpringBootWizard.this.model.getDependencyFilter().addListener((ValueListener)new UIValueListener<Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>>(){

                    protected void uiGotValue(LiveExpression<Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>> exp, Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> value) {
                        DependencyPage.this.applyFilter((Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>)value, expandable, checkboxes);
                    }
                });
            }
            return sections;
        }
    }

    public class PageThree
    extends WizardPageWithSections {
        protected PageThree() {
            super("page3", "New Spring Starter Project", null);
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            sections.add((WizardPageSection)new GroupSection((IPageWithSections)this, "Site Info", new WizardPageSection[]{new StringFieldSection((IPageWithSections)this, "Base Url", ((NewSpringBootWizard)NewSpringBootWizard.this).model.baseUrl, ((NewSpringBootWizard)NewSpringBootWizard.this).model.baseUrlValidator), new DescriptionSection((IPageWithSections)this, ((NewSpringBootWizard)NewSpringBootWizard.this).model.downloadUrl).label("Full Url").readOnly(false)}));
            return sections;
        }
    }

    public class ProjectDetailsPage
    extends WizardPageWithSections {
        protected ProjectDetailsPage() {
            super("page1", "New Spring Starter Project", null);
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            FieldModel<String> projectName = NewSpringBootWizard.this.model.getProjectName();
            sections.add((WizardPageSection)new StringFieldSection((IPageWithSections)this, projectName));
            sections.add((WizardPageSection)new ProjectLocationSection((IPageWithSections)this, NewSpringBootWizard.this.model.getLocation(), (LiveExpression)projectName.getVariable(), NewSpringBootWizard.this.model.getLocationValidator()));
            WizardPageSection radios = NewSpringBootWizard.this.createRadioGroupsSection(this);
            if (radios != null) {
                sections.add(radios);
            }
            for (FieldModel<String> fieldModel : ((NewSpringBootWizard)NewSpringBootWizard.this).model.stringInputs) {
                if (projectName == fieldModel) continue;
                sections.add((WizardPageSection)new StringFieldSection((IPageWithSections)this, fieldModel));
            }
            WorkingSetSection workingSetSection = new WorkingSetSection((IPageWithSections)this, NewSpringBootWizard.this.selection);
            NewSpringBootWizard.this.workingSetSection = workingSetSection;
            sections.add(workingSetSection);
            return sections;
        }
    }
}

