/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPreferences;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.DefaultDependencies;
import org.springframework.ide.eclipse.boot.wizard.DependencyFilterBox;
import org.springframework.ide.eclipse.boot.wizard.FieldArrayModel;
import org.springframework.ide.eclipse.boot.wizard.HierarchicalMultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.boot.wizard.PopularityTracker;
import org.springframework.ide.eclipse.boot.wizard.PreferredSelections;
import org.springframework.ide.eclipse.boot.wizard.RadioGroup;
import org.springframework.ide.eclipse.boot.wizard.RadioGroups;
import org.springframework.ide.eclipse.boot.wizard.RadioInfo;
import org.springframework.ide.eclipse.boot.wizard.TypeRadioInfo;
import org.springframework.ide.eclipse.boot.wizard.UrlMaker;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportUtils;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectLocationValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectNameValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.UrlValidator;
import org.springsource.ide.eclipse.commons.livexp.ui.ProjectLocationSection;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class NewSpringBootWizardModel {
    private static final Map<String, BuildType> KNOWN_TYPES = new HashMap<String, BuildType>();
    private static final Map<String, String> KNOWN_STRING_INPUTS;
    private static final Map<String, String> KNOWN_SINGLE_SELECTS;
    private final URLConnectionFactory urlConnectionFactory;
    private final String JSON_URL;
    private PopularityTracker popularities;
    private PreferredSelections preferredSelections;
    private DefaultDependencies defaultDependencies;
    public final FieldArrayModel<String> stringInputs = new FieldArrayModel(new FieldModel[0]);
    public final HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies = new HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency>(InitializrServiceSpec.Dependency.class, "dependencies").label("Dependencies:");
    private final FieldModel<String> projectName;
    private final LiveVariable<String> location;
    private final NewProjectLocationValidator locationValidator;
    private boolean allowUIThread = false;
    public final LiveVariable<String> baseUrl;
    public final LiveExpression<ValidationResult> baseUrlValidator;
    public final LiveVariable<String> downloadUrl = new LiveVariable();
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private RadioGroups radioGroups = new RadioGroups();
    private RadioGroup bootVersion;
    private DependencyFilterBox filterBox = new DependencyFilterBox();

    static {
        KNOWN_TYPES.put("gradle-project", BuildType.GRADLE);
        KNOWN_TYPES.put("maven-project", BuildType.MAVEN);
        KNOWN_TYPES.put("gradle.zip", BuildType.GRADLE);
        KNOWN_TYPES.put("starter.zip", BuildType.MAVEN);
        KNOWN_STRING_INPUTS = new LinkedHashMap<String, String>();
        KNOWN_STRING_INPUTS.put("name", "Name");
        KNOWN_STRING_INPUTS.put("groupId", "Group");
        KNOWN_STRING_INPUTS.put("artifactId", "Artifact");
        KNOWN_STRING_INPUTS.put("version", "Version");
        KNOWN_STRING_INPUTS.put("description", "Description");
        KNOWN_STRING_INPUTS.put("packageName", "Package");
        KNOWN_SINGLE_SELECTS = new LinkedHashMap<String, String>();
        KNOWN_SINGLE_SELECTS.put("packaging", "Packaging:");
        KNOWN_SINGLE_SELECTS.put("javaVersion", "Java Version:");
        KNOWN_SINGLE_SELECTS.put("language", "Language:");
        KNOWN_SINGLE_SELECTS.put("bootVersion", "Spring Boot Version:");
    }

    public NewSpringBootWizardModel(IPreferenceStore prefs) throws Exception {
        this(BootActivator.getUrlConnectionFactory(), prefs);
    }

    public NewSpringBootWizardModel() throws Exception {
        this(BootActivator.getUrlConnectionFactory(), BootWizardActivator.getDefault().getPreferenceStore());
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, IPreferenceStore prefs) throws Exception {
        this(urlConnectionFactory, BootPreferences.getInitializrUrl(), prefs);
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, String jsonUrl, IPreferenceStore prefs) throws Exception {
        this.popularities = new PopularityTracker(prefs);
        this.preferredSelections = new PreferredSelections(prefs);
        this.defaultDependencies = new DefaultDependencies(prefs);
        this.urlConnectionFactory = urlConnectionFactory;
        this.JSON_URL = jsonUrl;
        this.baseUrl = new LiveVariable((Object)"<computed>");
        this.baseUrlValidator = new UrlValidator("Base Url", this.baseUrl);
        this.discoverOptions(this.stringInputs, this.dependencies);
        this.dependencies.sort();
        this.projectName = this.stringInputs.getField("name");
        this.projectName.validator((LiveExpression)new NewProjectNameValidator((LiveExpression)this.projectName.getVariable()));
        this.location = new LiveVariable((Object)ProjectLocationSection.getDefaultProjectLocation((String)((String)this.projectName.getValue())));
        this.locationValidator = new NewProjectLocationValidator("Location", this.location, (LiveExpression)this.projectName.getVariable());
        Assert.isNotNull(this.projectName, (String)("The service at " + this.JSON_URL + " doesn't specify a 'name' text input"));
        UrlMaker computedUrl = new UrlMaker((LiveExpression<String>)this.baseUrl);
        for (FieldModel<String> fieldModel : this.stringInputs) {
            computedUrl.addField(fieldModel);
        }
        computedUrl.addField(this.dependencies);
        for (RadioGroup radioGroup : this.radioGroups.getGroups()) {
            computedUrl.addField(radioGroup);
        }
        computedUrl.addListener((ValueListener)new ValueListener<String>(){

            public void gotValue(LiveExpression<String> exp, String value) {
                NewSpringBootWizardModel.this.downloadUrl.setValue((Object)value);
            }
        });
        this.addBuildTypeValidator();
        this.preferredSelections.restore(this);
        this.defaultDependencies.restore(this.dependencies);
    }

    private void addBuildTypeValidator() {
        RadioGroup buildTypeGroup = this.getRadioGroups().getGroup("type");
        if (buildTypeGroup != null) {
            buildTypeGroup.validator((LiveExpression)new Validator(buildTypeGroup){
                {
                    this.dependsOn((LiveExpression)radioGroup.getVariable());
                }

                protected ValidationResult compute() {
                    ImportStrategy s = NewSpringBootWizardModel.this.getImportStrategy();
                    if (s == null) {
                        return ValidationResult.error((String)"No 'type' selected");
                    }
                    if (!s.isSupported()) {
                        return ValidationResult.error((String)s.getNotInstalledMessage());
                    }
                    return ValidationResult.OK;
                }
            });
        }
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getMostPopular(int howMany) {
        return this.popularities.getMostPopular(this.dependencies, howMany);
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getDefaultDependencies() {
        return this.defaultDependencies.getDependencies(this.dependencies);
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getFrequentlyUsedDependencies(int numberOfMostPopular) {
        List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> defaultDependencies = this.getDefaultDependencies();
        Set<String> defaultDependecyIds = this.getDefaultDependenciesIds();
        this.getMostPopular(numberOfMostPopular).stream().filter(checkboxModel -> !defaultDependecyIds.contains(((InitializrServiceSpec.Dependency)checkboxModel.getValue()).getId())).forEach(defaultDependencies::add);
        defaultDependencies.sort(new Comparator<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>(){

            @Override
            public int compare(CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> d1, CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> d2) {
                return d1.getLabel().compareTo(d2.getLabel());
            }
        });
        return defaultDependencies;
    }

    public Set<String> getDefaultDependenciesIds() {
        return this.defaultDependencies.getDependciesIdSet();
    }

    public void updateUsageCounts() {
        this.popularities.incrementUsageCount(this.dependencies.getCurrentSelection());
    }

    public boolean saveDefaultDependencies() {
        return this.defaultDependencies.save(this.dependencies);
    }

    public void performFinish(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        mon.beginTask("Importing " + (String)this.baseUrl.getValue(), 4);
        this.updateUsageCounts();
        this.preferredSelections.save(this);
        DownloadManager downloader = null;
        try {
            try {
                downloader = new DownloadManager(this.urlConnectionFactory).allowUIThread(this.allowUIThread);
                DownloadableItem zip = new DownloadableItem(this.newURL((String)this.downloadUrl.getValue()), downloader);
                String projectNameValue = (String)this.projectName.getValue();
                CodeSet cs = CodeSet.fromZip(projectNameValue, zip, (IPath)new Path("/"));
                ImportStrategy strat = this.getImportStrategy();
                if (strat == null) {
                    strat = BuildType.GENERAL.getDefaultStrategy();
                }
                IRunnableWithProgress oper = strat.createOperation(ImportUtils.importConfig((IPath)new Path((String)this.location.getValue()), projectNameValue, cs));
                oper.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)mon, (int)3));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameValue);
                this.addToWorkingSets(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)mon, (int)1));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (downloader != null) {
                downloader.dispose();
            }
            mon.done();
        }
    }

    public ImportStrategy getImportStrategy() {
        TypeRadioInfo selected = this.getSelectedTypeRadio();
        if (selected != null) {
            return selected.getImportStrategy();
        }
        return null;
    }

    public void setImportStrategy(ImportStrategy is) {
        RadioGroup typeRadios = this.getRadioGroups().getGroup("type");
        RadioInfo radio = typeRadios.getRadio(is.getId());
        Assert.isLegal((radio != null ? 1 : 0) != 0);
        typeRadios.setValue(radio);
    }

    public BuildType getBuildType() {
        ImportStrategy is = this.getImportStrategy();
        if (is != null) {
            return is.getBuildType();
        }
        return null;
    }

    private TypeRadioInfo getSelectedTypeRadio() {
        RadioGroup buildTypeRadios = this.getRadioGroups().getGroup("type");
        if (buildTypeRadios != null) {
            return (TypeRadioInfo)buildTypeRadios.getSelection().selection.getValue();
        }
        return null;
    }

    private void addToWorkingSets(IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Add '" + project.getName() + "' to working sets", 1);
        try {
            if (this.workingSets == null || this.workingSets.length == 0) {
                return;
            }
            IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
            wsm.addToWorkingSets((IAdaptable)project, this.workingSets);
        }
        finally {
            monitor.done();
        }
    }

    private void discoverOptions(FieldArrayModel<String> fields, HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies) throws Exception {
        InitializrServiceSpec serviceSpec = this.parseJsonFrom(new URL(this.JSON_URL));
        Map textInputs = serviceSpec.getTextInputs();
        for (Map.Entry<String, String> e : KNOWN_STRING_INPUTS.entrySet()) {
            String name = e.getKey();
            String defaultValue = (String)textInputs.get(name);
            if (defaultValue == null) continue;
            fields.add((FieldModel<String>)new StringFieldModel(name, defaultValue).label(e.getValue()));
        }
        String groupName = "type";
        RadioGroup group = this.radioGroups.ensureGroup(groupName);
        group.label("Type:");
        InitializrServiceSpec.Type[] typeArray = serviceSpec.getTypeOptions(groupName);
        int n = typeArray.length;
        int defaultValue = 0;
        while (defaultValue < n) {
            InitializrServiceSpec.Type type = typeArray[defaultValue];
            BuildType bt = KNOWN_TYPES.get(type.getId());
            if (bt != null) {
                for (ImportStrategy is : bt.getImportStrategies()) {
                    TypeRadioInfo radio = new TypeRadioInfo(groupName, type, is);
                    radio.setLabel(is.displayName());
                    group.add(radio);
                }
            }
            ++defaultValue;
        }
        group.getSelection().selection.addListener((ValueListener)new ValueListener<RadioInfo>(){

            public void gotValue(LiveExpression<RadioInfo> exp, RadioInfo value) {
                try {
                    if (value != null) {
                        URI base = new URI(NewSpringBootWizardModel.this.JSON_URL);
                        URI resolved = base.resolve(((TypeRadioInfo)value).getAction());
                        NewSpringBootWizardModel.this.baseUrl.setValue((Object)resolved.toString());
                    }
                }
                catch (Exception e) {
                    BootWizardActivator.log(e);
                }
            }
        });
        for (Map.Entry<String, String> e : KNOWN_SINGLE_SELECTS.entrySet()) {
            String groupName2 = e.getKey();
            RadioGroup group2 = this.radioGroups.ensureGroup(groupName2);
            group2.label(e.getValue());
            this.addOptions(group2, serviceSpec.getSingleSelectOptions(groupName2));
            if (!groupName2.equals("bootVersion")) continue;
            this.bootVersion = group2;
        }
        InitializrServiceSpec.DependencyGroup[] dependencyGroupArray = serviceSpec.getDependencies();
        int n2 = dependencyGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            InitializrServiceSpec.DependencyGroup dgroup = dependencyGroupArray[n3];
            String catName = dgroup.getName();
            InitializrServiceSpec.Dependency[] dependencyArray = dgroup.getContent();
            int n4 = dependencyArray.length;
            int n5 = 0;
            while (n5 < n4) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n5];
                dependencies.choice(catName, dep.getName(), dep, dep.getDescription(), this.createEnablementExp(this.bootVersion, dep));
                ++n5;
            }
            ++n3;
        }
    }

    private LiveExpression<Boolean> createEnablementExp(final RadioGroup bootVersion, final InitializrServiceSpec.Dependency dep) {
        try {
            String versionRange = dep.getVersionRange();
            if (StringUtils.isNotBlank((CharSequence)versionRange)) {
                return new LiveExpression<Boolean>(){
                    {
                        this.dependsOn((LiveExpression)radioGroup.getSelection().selection);
                    }

                    protected Boolean compute() {
                        RadioInfo radio = (RadioInfo)bootVersion.getValue();
                        if (radio != null) {
                            String versionString = radio.getValue();
                            return dep.isSupportedFor(versionString);
                        }
                        return true;
                    }
                };
            }
        }
        catch (Exception e) {
            BootWizardActivator.log(e);
        }
        return LiveExpression.TRUE;
    }

    private void addOptions(RadioGroup group, InitializrServiceSpec.Option[] options) {
        InitializrServiceSpec.Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            InitializrServiceSpec.Option option = optionArray[n2];
            RadioInfo radio = new RadioInfo(group.getName(), option.getId(), option.isDefault());
            radio.setLabel(option.getName());
            group.add(radio);
            ++n2;
        }
    }

    private InitializrServiceSpec parseJsonFrom(URL url) throws Exception {
        return InitializrServiceSpec.parseFrom((URLConnectionFactory)this.urlConnectionFactory, (URL)url);
    }

    private URL newURL(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            BootWizardActivator.log(e);
            return null;
        }
    }

    public void allowUIThread(boolean allow) {
        this.allowUIThread = allow;
    }

    public LiveExpression<ValidationResult> getLocationValidator() {
        return this.locationValidator;
    }

    public LiveVariable<String> getLocation() {
        return this.location;
    }

    public FieldModel<String> getProjectName() {
        return this.projectName;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public RadioGroups getRadioGroups() {
        return this.radioGroups;
    }

    public RadioGroup getBootVersion() {
        return this.bootVersion;
    }

    public FieldModel<String> getArtifactId() {
        String fieldName = "artifactId";
        return this.getStringInput(fieldName);
    }

    public FieldModel<String> getStringInput(String fieldName) {
        for (FieldModel<String> fieldModel : this.stringInputs) {
            if (!fieldName.equals(fieldModel.getName())) continue;
            return fieldModel;
        }
        return null;
    }

    public LiveVariable<String> getDependencyFilterBoxText() {
        return this.filterBox.getText();
    }

    public LiveExpression<Filter<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>> getDependencyFilter() {
        return this.filterBox.getFilter();
    }

    public void addDependency(String dependencyId) {
        for (String catName : this.dependencies.getCategories()) {
            MultiSelectionFieldModel<InitializrServiceSpec.Dependency> cat = this.dependencies.getContents(catName);
            InitializrServiceSpec.Dependency[] dependencyArray = cat.getChoices();
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                InitializrServiceSpec.Dependency dep = dependencyArray[n2];
                if (dependencyId.equals(dep.getId())) {
                    cat.select(dep);
                    return;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("No such dependency: " + dependencyId);
    }
}

