/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springframework.ide.eclipse.boot.wizard.CheckBoxesSection;
import org.springframework.ide.eclipse.boot.wizard.HierarchicalMultiSelectionFieldModel;

public class PopularityTracker {
    public static final String PREFIX = String.valueOf(PopularityTracker.class.getName()) + ".";
    private IPreferenceStore store;

    public PopularityTracker(IPreferenceStore store) {
        this.store = store;
    }

    protected String key(String id) {
        String key = String.valueOf(PREFIX) + id;
        return key;
    }

    public void incrementUsageCount(InitializrServiceSpec.Dependency d) {
        this.incrementUsageCount(d.getId());
    }

    public int getUsageCount(InitializrServiceSpec.Dependency d) {
        return this.getUsageCount(d.getId());
    }

    public int getUsageCount(String id) {
        return this.store.getInt(this.key(id));
    }

    private void incrementUsageCount(String id) {
        String key = this.key(id);
        this.store.setValue(key, this.store.getInt(key) + 1);
    }

    public void incrementUsageCount(Collection<InitializrServiceSpec.Dependency> selected) {
        for (InitializrServiceSpec.Dependency d : selected) {
            this.incrementUsageCount(d);
        }
    }

    public List<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> getMostPopular(HierarchicalMultiSelectionFieldModel<InitializrServiceSpec.Dependency> dependencies, int howMany) {
        final HashMap<CheckBoxesSection.CheckBoxModel, Integer> useCounts = new HashMap<CheckBoxesSection.CheckBoxModel, Integer>();
        ArrayList<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>> allUsedBoxes = new ArrayList<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>();
        for (String category : dependencies.getCategories()) {
            allUsedBoxes.addAll(dependencies.getContents(category).getCheckBoxModels());
        }
        Iterator iterator = allUsedBoxes.iterator();
        while (iterator.hasNext()) {
            CheckBoxesSection.CheckBoxModel cb = (CheckBoxesSection.CheckBoxModel)iterator.next();
            int useCount = this.getUsageCount((InitializrServiceSpec.Dependency)cb.getValue());
            if (useCount == 0) {
                iterator.remove();
                continue;
            }
            useCounts.put(cb, this.getUsageCount((InitializrServiceSpec.Dependency)cb.getValue()));
        }
        Collections.sort(allUsedBoxes, new Comparator<CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency>>(){

            @Override
            public int compare(CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> o1, CheckBoxesSection.CheckBoxModel<InitializrServiceSpec.Dependency> o2) {
                return (Integer)useCounts.get(o2) - (Integer)useCounts.get(o1);
            }
        });
        howMany = Math.min(allUsedBoxes.size(), howMany);
        ArrayList<CheckBoxesSection.CheckBoxModel> result = new ArrayList<CheckBoxesSection.CheckBoxModel>();
        int i = 0;
        while (i < howMany) {
            result.add((CheckBoxesSection.CheckBoxModel)allUsedBoxes.get(i));
            ++i;
        }
        return Collections.unmodifiableList(result);
    }
}

