/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springframework.ide.eclipse.boot.wizard.NewSpringBootWizardModel;
import org.springframework.ide.eclipse.boot.wizard.RadioGroup;
import org.springframework.ide.eclipse.boot.wizard.RadioInfo;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;

public class PreferredSelections {
    private String PREFIX = String.valueOf(PreferredSelections.class.getName()) + ".";
    private IPreferenceStore store;

    public PreferredSelections(IPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.store = store;
    }

    protected String key(String id) {
        String key = String.valueOf(this.PREFIX) + id;
        return key;
    }

    public void save(NewSpringBootWizardModel wizard) {
        for (FieldModel<String> fieldModel : wizard.stringInputs) {
            if (!this.isInteresting(fieldModel)) continue;
            this.put(fieldModel.getName(), (String)fieldModel.getValue());
        }
        for (RadioGroup radioGroup : wizard.getRadioGroups().getGroups()) {
            if (!this.isInteresting(radioGroup)) continue;
            this.put(radioGroup.getName(), ((RadioInfo)radioGroup.getValue()).getValue());
        }
    }

    protected boolean isInteresting(RadioGroup input) {
        return true;
    }

    protected boolean isInteresting(FieldModel<String> input) {
        return true;
    }

    public void restore(NewSpringBootWizardModel wizard) {
        for (FieldModel<String> fieldModel : wizard.stringInputs) {
            if (!this.isInteresting(fieldModel)) continue;
            String v = this.get(fieldModel.getName(), (String)fieldModel.getValue());
            fieldModel.setValue((Object)v);
        }
        for (RadioGroup radioGroup : wizard.getRadioGroups().getGroups()) {
            String choiceId;
            RadioInfo info;
            if (!this.isInteresting(radioGroup) || (info = radioGroup.getRadio(choiceId = this.get(radioGroup.getName(), null))) == null) continue;
            radioGroup.getVariable().setValue((Object)info);
        }
    }

    private void put(String id, String value) {
        String key = this.key(id);
        this.store.setValue(key, value);
    }

    private String get(String name, String dflt) {
        String key = this.key(name);
        String v = this.store.getString(key);
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        return dflt;
    }
}

