/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class SearchBoxSection
extends WizardPageSection
implements Disposable {
    private Text searchBox;
    private LiveVariable<String> model;
    private ValueListener<String> modelListener;

    public SearchBoxSection(IPageWithSections owner, LiveVariable<String> model) {
        super(owner);
        this.model = model;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return OK_VALIDATOR;
    }

    public void createContents(Composite page) {
        this.searchBox = new Text(page, 2436);
        this.searchBox.setMessage(this.getSearchHint());
        this.searchBox.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchBoxSection.this.model.setValue((Object)SearchBoxSection.this.searchBox.getText());
            }
        });
        this.modelListener = new UIValueListener<String>(){

            public void uiGotValue(LiveExpression<String> exp, String ignore) {
                String newText = (String)SearchBoxSection.this.model.getValue();
                if (SearchBoxSection.this.searchBox.isDisposed()) {
                    SearchBoxSection.this.dispose();
                } else {
                    String oldText = SearchBoxSection.this.searchBox.getText();
                    if (!oldText.equals(newText)) {
                        SearchBoxSection.this.searchBox.setText(newText);
                    }
                }
            }
        };
        this.model.addListener((ValueListener)this.modelListener);
    }

    protected String getSearchHint() {
        return "Type a text to search";
    }

    public void dispose() {
        if (this.modelListener != null) {
            this.model.removeListener(this.modelListener);
            this.modelListener = null;
        }
        this.searchBox.dispose();
    }
}

