/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.boot.wizard.content.ContributedImportStrategies;
import org.springframework.ide.eclipse.boot.wizard.importing.GeneralProjectStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategies;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategyHolder;
import org.springframework.ide.eclipse.boot.wizard.importing.MavenStrategy;

public enum BuildType {
    MAVEN("pom.xml", MavenStrategy.class.getName(), "M2E (Eclipse Maven Tooling) is not installed"),
    GRADLE("build.gradle"),
    GENERAL(null, GeneralProjectStrategy.class.getName(), "NA");

    private static final ContributedImportStrategies contributions;
    private Path buildScriptPath;
    private List<ImportStrategyHolder> strategies = new ArrayList<ImportStrategyHolder>();
    private String displayName;
    private boolean hasDefaultStrategy = false;
    public static final BuildType DEFAULT;

    static {
        contributions = new ContributedImportStrategies();
        DEFAULT = MAVEN;
    }

    private BuildType(String buildScriptPath) {
        if (buildScriptPath != null) {
            this.buildScriptPath = new Path(buildScriptPath);
        }
    }

    private BuildType(String buildScriptPath, String importStrategyClass, String notInstalledMessage) {
        this(buildScriptPath);
        this.hasDefaultStrategy = true;
        this.addStrategy(new ImportStrategyHolder(this, ImportStrategies.forClass(importStrategyClass), notInstalledMessage, "Default"));
    }

    public IPath getBuildScript() {
        return this.buildScriptPath;
    }

    public List<ImportStrategy> getImportStrategies() {
        contributions.initialize();
        ArrayList<ImportStrategy> instances = new ArrayList<ImportStrategy>(this.strategies.size());
        for (ImportStrategyHolder f : this.strategies) {
            instances.add(f.get());
        }
        return Collections.unmodifiableList(instances);
    }

    public String displayName() {
        if (this.displayName == null) {
            String name = this.name();
            this.displayName = String.valueOf(name.substring(0, 1)) + name.substring(1).toLowerCase();
        }
        return this.displayName;
    }

    public void addStrategy(ImportStrategyHolder strategyHolder) {
        this.strategies.add(strategyHolder);
    }

    public ImportStrategy getDefaultStrategy() {
        Assert.isLegal((boolean)this.hasDefaultStrategy);
        return this.getImportStrategies().get(0);
    }
}

