/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.ZipFileCodeSet;
import org.springsource.ide.eclipse.commons.core.util.OsUtils;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;
import org.springsource.ide.eclipse.commons.frameworks.core.util.IOUtil;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public abstract class CodeSet {
    private static final boolean IS_WINDOWS = OsUtils.isWindows();
    protected String name;
    private List<BuildType> buildTypes;

    public CodeSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CodeSet fromZip(String name, DownloadableItem zip, IPath root) {
        return new ZipFileCodeSet(name, zip, root);
    }

    public List<BuildType> getBuildTypes() throws UIThreadDownloadDisallowed {
        if (this.buildTypes == null) {
            ArrayList<BuildType> buildTypes = new ArrayList<BuildType>();
            BuildType[] buildTypeArray = BuildType.values();
            int n = buildTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuildType type = buildTypeArray[n2];
                IPath scriptFile = type.getBuildScript();
                if (scriptFile != null && this.hasFile(scriptFile)) {
                    buildTypes.add(type);
                }
                ++n2;
            }
            if (buildTypes.isEmpty()) {
                buildTypes.add(BuildType.GENERAL);
            }
            this.buildTypes = buildTypes;
        }
        return this.buildTypes;
    }

    public abstract boolean exists() throws Exception;

    public abstract boolean hasFile(IPath var1) throws UIThreadDownloadDisallowed;

    public abstract boolean hasFolder(IPath var1);

    public final boolean hasFile(String path) throws UIThreadDownloadDisallowed {
        return this.hasFile((IPath)new Path(path));
    }

    public abstract <T> T each(Processor<T> var1) throws Exception;

    public void createAt(final File location) throws Exception {
        if (location.exists() && !FileUtils.deleteQuietly((File)location)) {
            throw new IOException("Data already exists at location and it could not be deleted: " + location);
        }
        this.each(new Processor<Void>(){

            @Override
            public Void doit(CodeSetEntry e) throws Exception {
                IPath path = e.getPath();
                File target = new File(location, path.toString());
                if (e.isDirectory()) {
                    target.mkdirs();
                } else {
                    int mode;
                    IOUtil.pipe((InputStream)e.getData(), (File)target);
                    if (!IS_WINDOWS && (mode = e.getUnixMode()) > 0) {
                        Files.setPosixFilePermissions(target.toPath(), OsUtils.posixFilePermissions((int)mode));
                    }
                }
                return null;
            }
        });
    }

    public ValidationResult validateBuildType(BuildType buildType) throws UIThreadDownloadDisallowed {
        List<BuildType> validBuildTypes = this.getBuildTypes();
        if (validBuildTypes.contains((Object)buildType)) {
            return ValidationResult.OK;
        }
        IPath expectedScript = buildType.getBuildScript();
        if (expectedScript != null) {
            return ValidationResult.error((String)("Can't use '" + buildType.displayName() + "': There is no '" + expectedScript + "'"));
        }
        StringBuilder message = new StringBuilder("Should be imported as ");
        boolean first = true;
        for (BuildType bt : validBuildTypes) {
            if (!first) {
                message.append(" or ");
            }
            message.append("'" + bt.displayName() + "'");
            first = false;
        }
        return ValidationResult.error((String)message.toString());
    }

    public abstract <T> T readFileEntry(String var1, Processor<T> var2) throws Exception;

    public abstract class CodeSetEntry {
        public abstract IPath getPath();

        public abstract boolean isDirectory();

        public abstract InputStream getData() throws IOException;

        public int getUnixMode() {
            return 0;
        }
    }

    public static abstract class Processor<T> {
        public abstract T doit(CodeSetEntry var1) throws Exception;
    }
}

