/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.content.ContentProvider;
import org.springframework.ide.eclipse.boot.wizard.content.ContentType;
import org.springframework.ide.eclipse.boot.wizard.content.GSContent;
import org.springframework.ide.eclipse.boot.wizard.content.TypedContentManager;
import org.springframework.ide.eclipse.boot.wizard.github.auth.AuthenticatedDownloader;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.util.JobUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;

public class ContentManager {
    private final Map<Class<?>, TypedContentManager<?>> byClass = new HashMap();
    private final List<ContentType<?>> types = new ArrayList();
    protected LiveVariable<DownloadState> prefetchContentTracker = new LiveVariable((Object)DownloadState.NOT_STARTED);
    protected LiveVariable<DownloadState> prefetchContentProviderPropertiesTracker = new LiveVariable((Object)DownloadState.NOT_STARTED);

    public <T extends GSContent> void register(Class<T> klass, String description, ContentProvider<T> provider) {
        try {
            Assert.isLegal((!this.byClass.containsKey(klass) ? 1 : 0) != 0, (String)("A content provider for " + klass + " is already registered"));
            this.prefetchContentTracker.setValue((Object)DownloadState.NOT_STARTED);
            ContentType<T> ctype = new ContentType<T>(klass, description);
            this.types.add(ctype);
            DownloadManager downloader = this.downloadManagerFor(klass);
            this.byClass.put(klass, new TypedContentManager<T>(downloader, provider));
        }
        catch (Throwable e) {
            BootWizardActivator.log(e);
        }
    }

    public DownloadManager downloadManagerFor(Class<?> contentType) throws IllegalStateException, IOException {
        return new DownloadManager((DownloadManager.DownloadService)new AuthenticatedDownloader(), new File(BootWizardActivator.getDefault().getStateLocation().toFile(), contentType.getSimpleName())).clearCache();
    }

    public <T> T[] get(Class<T> type) {
        TypedContentManager<?> man = this.byClass.get(type);
        if (man != null) {
            return man.getAll();
        }
        return null;
    }

    public ContentType<?>[] getTypes() {
        return this.types.toArray(new ContentType[this.types.size()]);
    }

    public Object[] get(ContentType<?> ct) {
        if (ct != null) {
            return this.get(ct.getKlass());
        }
        return null;
    }

    public Object[] getWithPrefetchCheck(ContentType<?> ct) {
        if (this.prefetchContentTracker.getValue() != DownloadState.IS_DOWNLOADING) {
            return this.get(ct);
        }
        return null;
    }

    public static <T extends GSContent> ContentManager singleton(final Class<T> type, String description, final T item) {
        ContentManager cm = new ContentManager();
        cm.register(type, description, new ContentProvider<T>(){

            @Override
            public T[] fetch(DownloadManager downloader) {
                GSContent[] array = (GSContent[])Array.newInstance(type, 1);
                item.setDownloader(downloader);
                array[0] = item;
                return array;
            }
        });
        return cm;
    }

    public void prefetchAllContent(IProgressMonitor monitor) {
        this.prefetchContentTracker.setValue((Object)DownloadState.IS_DOWNLOADING);
        try {
            ContentType<?>[] allTypes = this.getTypes();
            if (allTypes != null) {
                ContentType<?>[] contentTypeArray = allTypes;
                int n = allTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentType<?> type = contentTypeArray[n2];
                    if (monitor.isCanceled()) break;
                    this.get(type);
                    ++n2;
                }
            }
            this.prefetchContentTracker.setValue((Object)DownloadState.DOWNLOADING_COMPLETED);
        }
        finally {
            this.prefetchContentTracker.setValue((Object)DownloadState.DOWNLOADED);
        }
    }

    public LiveVariable<DownloadState> getPrefetchContentTracker() {
        return this.prefetchContentTracker;
    }

    public LiveVariable<DownloadState> getPrefetchContentProviderPropertiesTracker() {
        return this.prefetchContentProviderPropertiesTracker;
    }

    public void prefetchInBackground(IRunnableContext runnableContext) {
        try {
            JobUtil.runBackgroundJobWithUIProgress(monitor -> this.prefetch(monitor), (IRunnableContext)runnableContext, (String)"Prefetching content...");
        }
        catch (Exception e) {
            BootWizardActivator.log(e);
        }
    }

    protected void prefetch(IProgressMonitor monitor) {
        String downloadLabel = "Downloading all content. Please wait...";
        this.prefetchAllContent((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)downloadLabel, (int)50));
    }

    public void disposePrefetchTrackingListeners() {
        DownloadState propertiesDownloadState = (DownloadState)((Object)this.prefetchContentProviderPropertiesTracker.getValue());
        DownloadState contentDownloadState = (DownloadState)((Object)this.prefetchContentTracker.getValue());
        this.prefetchContentProviderPropertiesTracker.dispose();
        this.prefetchContentTracker.dispose();
        this.prefetchContentProviderPropertiesTracker = new LiveVariable((Object)propertiesDownloadState);
        this.prefetchContentTracker = new LiveVariable((Object)contentDownloadState);
    }

    public static enum DownloadState {
        IS_DOWNLOADING,
        DOWNLOADING_COMPLETED,
        DOWNLOADED,
        NOT_STARTED;

    }
}

