/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.wizard.content.Describable;
import org.springframework.ide.eclipse.boot.wizard.content.DisplayNameable;
import org.springframework.ide.eclipse.boot.wizard.content.GSContent;

public class ContentType<T extends GSContent>
implements Describable,
DisplayNameable {
    private final Class<T> klass;
    private final String description;

    public ContentType(Class<T> klass, String description) {
        Assert.isNotNull(klass);
        Assert.isNotNull((Object)description);
        this.klass = klass;
        this.description = description;
    }

    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ContentType(" + this.klass.getSimpleName() + ")";
    }

    @Override
    public String getDisplayName() {
        return this.beatifyClassName(this.klass.getSimpleName());
    }

    private String beatifyClassName(String simpleName) {
        StringBuilder result = new StringBuilder();
        Matcher m = Pattern.compile("[A-Z]").matcher(simpleName);
        int pos1 = 0;
        boolean found = m.find();
        while (found) {
            int pos2 = m.start();
            if (pos2 > pos1) {
                result.append(String.valueOf(simpleName.substring(pos1, pos2)) + " ");
            }
            pos1 = pos2;
            found = m.find();
        }
        if (pos1 >= 0) {
            result.append(simpleName.substring(pos1));
        }
        return result.toString();
    }
}

