/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategyFactory;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategyHolder;

public class ContributedImportStrategies {
    private static final String EXTENSION_POINT = "org.springframework.ide.eclipse.wizard.import.strategy";
    private boolean isInitialized;

    public synchronized void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.initializeFromExtensions();
        }
    }

    private void initializeFromExtensions() {
        try {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                element.createExecutableExtension("class");
                BuildType buildType = this.getBuildType(element);
                ImportStrategyHolder strategyHolder = new ImportStrategyHolder(buildType, this.getFactory(element), this.getNotInstalledMessage(element), this.getName(element));
                buildType.addStrategy(strategyHolder);
                ++n2;
            }
        }
        catch (Exception e) {
            BootWizardActivator.log(e);
        }
    }

    private String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    private String getNotInstalledMessage(IConfigurationElement element) {
        return element.getAttribute("notInstalledMessage");
    }

    private ImportStrategyFactory getFactory(final IConfigurationElement element) {
        return new ImportStrategyFactory(){

            @Override
            public ImportStrategy create(BuildType buildType, String name, String notInstalledMessage) throws Exception {
                ImportStrategyFactory factory = (ImportStrategyFactory)element.createExecutableExtension("class");
                return factory.create(buildType, name, notInstalledMessage);
            }
        };
    }

    private BuildType getBuildType(IConfigurationElement element) {
        return BuildType.valueOf(element.getAttribute("buildType"));
    }
}

