/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.boot.wizard.content.AGSContent;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.content.ZipFileCodeSet;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;

public class GSZipFileCodeSet
extends AGSContent {
    private final URI zipUrl;

    public GSZipFileCodeSet(URI zipUrl) {
        super(null);
        this.zipUrl = zipUrl;
    }

    @Override
    public String getDescription() {
        return "No description";
    }

    @Override
    public String getName() {
        this.getHomePage();
        return this.zipUrl.getPath();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public List<CodeSet> getCodeSets() throws UIThreadDownloadDisallowed {
        return Arrays.asList(new ZipFileCodeSet(this.getName(), this.getZip(), (IPath)new Path("/")));
    }

    @Override
    public URL getHomePage() {
        return null;
    }

    private URL zipUrl() {
        try {
            return this.zipUrl.toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    @Override
    public DownloadableItem getZip() {
        return new DownloadableItem(this.zipUrl(), this.downloader);
    }
}

