/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.content;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.content.GithubRepoContent;
import org.springframework.ide.eclipse.boot.wizard.content.ReferenceAppMetaData;
import org.springframework.ide.eclipse.boot.wizard.github.GithubClient;
import org.springframework.ide.eclipse.boot.wizard.github.Repo;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;

public class ReferenceApp
extends GithubRepoContent {
    public static final String[] readmes = new String[]{"README.md", "readme.md", "readme.MD", "README.MD", "readme.txt", "readme.TXT", "README.txt", "README.TXT", "readme", "README"};
    private final ReferenceAppMetaData metadata;
    private final GithubClient github;
    private Repo repo;
    private CodeSet codeset;
    public static final String REFERENCE_APP_DESCRIPTION = "A reference app is a larger, complete application that shows how to use spring properly in a more realistic context.";

    public ReferenceApp(ReferenceAppMetaData md, DownloadManager dl, GithubClient gh) {
        super(dl);
        Assert.isNotNull((Object)md);
        Assert.isNotNull((Object)md.getOwner());
        Assert.isNotNull((Object)md.getRepo());
        this.metadata = md;
        this.github = gh;
    }

    @Override
    public String getName() {
        String name = this.metadata.getName();
        if (name != null) {
            return name;
        }
        return this.metadata.getRepo();
    }

    @Override
    public Repo getRepo() {
        if (this.repo == null) {
            this.repo = this.github.getRepo(this.metadata.getOwner(), this.metadata.getRepo());
        }
        return this.repo;
    }

    public CodeSet getCodeSet() {
        if (this.codeset == null) {
            this.codeset = CodeSet.fromZip(this.getName(), this.getZip(), this.getRootPath());
        }
        return this.codeset;
    }

    public String getReadme() throws UIThreadDownloadDisallowed {
        CodeSet cs = this.getCodeSet();
        String[] stringArray = readmes;
        int n = readmes.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (cs.hasFile(name)) {
                return name;
            }
            ++n2;
        }
        return null;
    }

    public List<BuildType> getBuildTypes() throws UIThreadDownloadDisallowed {
        return this.getCodeSet().getBuildTypes();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public List<CodeSet> getCodeSets() throws UIThreadDownloadDisallowed {
        return Arrays.asList(this.getCodeSet());
    }
}

