/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.guides;

import java.util.HashSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.boot.wizard.guides.MultiSelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class CodeSetCheckBoxesSection
extends WizardPageSection {
    private final LiveExpression<String[]> options;
    private final MultiSelectionModel<String> model;
    private Group group;
    private WizardPageSection[] subsections;

    public CodeSetCheckBoxesSection(WizardPageWithSections owner, LiveExpression<String[]> options, MultiSelectionModel<String> model) {
        super((IPageWithSections)owner);
        this.model = model;
        this.options = options;
    }

    protected GridLayout createLayout() {
        return new GridLayout(2, true);
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.model.validator;
    }

    public void createContents(Composite page) {
        this.group = new Group(page, 0);
        this.group.setText("Code Sets");
        GridLayout layout = this.createLayout();
        this.group.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.group);
        this.options.addListener((ValueListener)new UIValueListener<String[]>(){
            private final HashSet<String> namesSeen = new HashSet();

            public void uiGotValue(LiveExpression<String[]> exp, String[] names) {
                if (CodeSetCheckBoxesSection.this.group == null || CodeSetCheckBoxesSection.this.group.isDisposed()) {
                    CodeSetCheckBoxesSection.this.options.removeListener((ValueListener)this);
                    return;
                }
                if (names == null) {
                    names = new String[]{};
                }
                if (CodeSetCheckBoxesSection.this.subsections != null) {
                    WizardPageSection[] wizardPageSectionArray = CodeSetCheckBoxesSection.this.subsections;
                    int n = wizardPageSectionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WizardPageSection subsection = wizardPageSectionArray[n2];
                        subsection.dispose();
                        ++n2;
                    }
                }
                CodeSetCheckBoxesSection.this.subsections = new WizardPageSection[Math.max(1, names.length)];
                if (names.length == 0) {
                    ((CodeSetCheckBoxesSection)CodeSetCheckBoxesSection.this).subsections[0] = new CommentSection(CodeSetCheckBoxesSection.this.owner, "No codesets");
                    CodeSetCheckBoxesSection.this.subsections[0].createContents((Composite)CodeSetCheckBoxesSection.this.group);
                }
                GridLayout newLayout = CodeSetCheckBoxesSection.this.createLayout();
                newLayout.numColumns = names.length > 2 ? 3 : 2;
                CodeSetCheckBoxesSection.this.group.setLayout((Layout)newLayout);
                int i = 0;
                while (i < names.length) {
                    ((CodeSetCheckBoxesSection)CodeSetCheckBoxesSection.this).subsections[i] = new CheckBox(CodeSetCheckBoxesSection.this.owner, names[i], CodeSetCheckBoxesSection.this.model);
                    if (this.isNewName(names[i])) {
                        ((CodeSetCheckBoxesSection)CodeSetCheckBoxesSection.this).model.selecteds.add((Object)names[i]);
                    }
                    CodeSetCheckBoxesSection.this.subsections[i].createContents((Composite)CodeSetCheckBoxesSection.this.group);
                    ++i;
                }
                CodeSetCheckBoxesSection.this.group.getParent().layout(true, true);
            }

            private boolean isNewName(String name) {
                boolean seen = this.namesSeen.contains(name);
                if (!seen) {
                    this.namesSeen.add(name);
                }
                return !seen;
            }
        });
    }

    private void clear(Group group) {
        Control[] children;
        Control[] controlArray = children = group.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    public static class CheckBox
    extends WizardPageSection {
        private final String name;
        private final MultiSelectionModel<String> model;
        private Button cb;

        public CheckBox(IPageWithSections owner, String name, MultiSelectionModel<String> model) {
            super(owner);
            this.name = name;
            this.model = model;
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.OK;
        }

        public void createContents(Composite page) {
            if (page != null && !page.isDisposed()) {
                this.cb = new Button(page, 32);
                this.cb.setText(this.name);
                this.cb.setSelection(this.model.selecteds.contains((Object)this.name));
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cb);
                this.cb.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    private void handleSelection() {
                        boolean add = cb.getSelection();
                        if (add) {
                            ((CheckBox)this).model.selecteds.add((Object)name);
                        } else {
                            ((CheckBox)this).model.selecteds.remove((Object)name);
                        }
                    }
                });
            }
        }

        public void dispose() {
            if (this.cb != null && !this.cb.isDisposed()) {
                this.cb.dispose();
                this.cb = null;
            }
        }
    }
}

