/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.guides;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class DownloadButtonSection
extends WizardPageSection {
    private final DownloadableModel model;
    private Button button;

    public DownloadButtonSection(WizardPageWithSections owner, DownloadableModel model) {
        super((IPageWithSections)owner);
        this.model = model;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return Validator.OK;
    }

    public void createContents(Composite page) {
        this.button = new Button(page, 8);
        this.button.setText("Download");
        this.enableDisable();
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.button);
        this.model.isDownloaded.addListener((ValueListener)new UIValueListener<Boolean>(){

            protected void uiGotValue(LiveExpression<Boolean> exp, Boolean value) {
                DownloadButtonSection.this.enableDisable();
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                DownloadButtonSection.this.model.performDownload(monitor);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    MessageDialog.openError((Shell)DownloadButtonSection.this.button.getShell(), (String)"Error downloading", (String)ExceptionUtil.getMessage((Throwable)e));
                    BootWizardActivator.log(e);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    private void enableDisable() {
        Boolean isDown = (Boolean)this.model.isDownloaded.getValue();
        if (isDown != null) {
            this.button.setEnabled(isDown.booleanValue());
        }
    }

    public static abstract class DownloadableModel {
        public final LiveExpression<Boolean> isDownloaded;

        public DownloadableModel(LiveExpression<Boolean> isDownloaded) {
            this.isDownloaded = isDownloaded;
        }

        public abstract void performDownload(IProgressMonitor var1);
    }
}

