/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.guides;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.content.ContentManager;
import org.springframework.ide.eclipse.boot.wizard.content.Describable;
import org.springframework.ide.eclipse.boot.wizard.content.GSContent;
import org.springframework.ide.eclipse.boot.wizard.content.GettingStartedContent;
import org.springframework.ide.eclipse.boot.wizard.content.GettingStartedGuide;
import org.springframework.ide.eclipse.boot.wizard.guides.MultiSelectionModel;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategies;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportUtils;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveSet;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import org.springsource.ide.eclipse.commons.ui.UiUtil;

public class GSImportWizardModel {
    private ContentManager contentManager = GettingStartedContent.getInstance();
    private final LiveVariable<ContentManager.DownloadState> prefetchContentTracker = this.contentManager.getPrefetchContentTracker();
    private final LiveVariable<ContentManager.DownloadState> prefetchContentProviderPropsTracker = this.contentManager.getPrefetchContentProviderPropertiesTracker();
    private final LiveVariable<GSContent> guide = new LiveVariable();
    private final LiveExpression<ValidationResult> guideValidator = new Validator(){
        {
            this.dependsOn((LiveExpression)GSImportWizardModel.this.guide);
            this.dependsOn((LiveExpression)GSImportWizardModel.this.prefetchContentProviderPropsTracker);
            this.dependsOn((LiveExpression)GSImportWizardModel.this.prefetchContentTracker);
        }

        protected ValidationResult compute() {
            ContentManager.DownloadState state = (ContentManager.DownloadState)((Object)GSImportWizardModel.this.prefetchContentProviderPropsTracker.getValue());
            if (state == ContentManager.DownloadState.IS_DOWNLOADING) {
                return ValidationResult.info((String)"Registering content providers. Please wait...");
            }
            state = (ContentManager.DownloadState)((Object)GSImportWizardModel.this.prefetchContentTracker.getValue());
            if (state == ContentManager.DownloadState.IS_DOWNLOADING) {
                return ValidationResult.info((String)"Downloading all content. Please wait...");
            }
            if (GSImportWizardModel.this.guide.getValue() == null) {
                return ValidationResult.error((String)"No GS content selected");
            }
            return ValidationResult.OK;
        }
    };
    private final LiveVariable<Object> rawSelection = new LiveVariable();
    private final LiveSet<String> codesets = new LiveSet(new HashSet());
    public final LiveExpression<String[]> validCodesetNames;
    private final LiveVariable<ImportStrategy> importStrategy;
    private final LiveExpression<ValidationResult> codesetValidator;
    private final LiveExpression<ValidationResult> importStrategyValidator;
    public final LiveExpression<Boolean> isDownloaded;
    private final LiveExpression<Void> autoSelectBuildType;
    public final LiveExpression<ValidationResult> downloadStatus;
    public final LiveExpression<String> description;
    public final LiveExpression<URL> homePage;
    private final LiveVariable<Boolean> enableOpenHomePage;

    public GSImportWizardModel() {
        this.codesets.addAll((Object[])GettingStartedGuide.defaultCodesetNames());
        this.validCodesetNames = new LiveExpression<String[]>(null){

            protected String[] compute() {
                try {
                    List<CodeSet> validSets;
                    GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                    if (g != null && (validSets = g.getCodeSets()) != null) {
                        String[] names = new String[validSets.size()];
                        int i = 0;
                        while (i < names.length) {
                            names[i] = validSets.get(i).getName();
                            ++i;
                        }
                        return names;
                    }
                }
                catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                    GSImportWizardModel.this.scheduleDownloadJob();
                }
                catch (Throwable e) {
                    BootWizardActivator.log(e);
                }
                return GettingStartedGuide.defaultCodesetNames();
            }
        };
        this.importStrategy = new LiveVariable((Object)BuildType.DEFAULT.getDefaultStrategy());
        this.codesetValidator = new CodeSetValidator(this.guide, this.codesets, this.validCodesetNames);
        this.importStrategyValidator = new Validator(){

            protected ValidationResult compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                ImportStrategy bt = (ImportStrategy)GSImportWizardModel.this.importStrategy.getValue();
                return GSImportWizardModel.this.validateImportStrategy(g, bt);
            }
        };
        this.isDownloaded = new LiveExpression<Boolean>(Boolean.valueOf(false)){

            protected Boolean compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null && !g.isDownloaded()) {
                    return false;
                }
                return true;
            }
        };
        this.autoSelectBuildType = new LiveExpression<Void>(){
            {
                this.dependsOn(GSImportWizardModel.this.isDownloaded);
                this.dependsOn((LiveExpression)GSImportWizardModel.this.guide);
            }

            protected Void compute() {
                ImportStrategy is;
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null && g.isDownloaded() && !GSImportWizardModel.this.validateImportStrategy(g, is = (ImportStrategy)GSImportWizardModel.this.importStrategy.getValue()).isOk()) {
                    for (ImportStrategy other : ImportStrategies.all()) {
                        if (other == is || !GSImportWizardModel.this.validateImportStrategy(g, other).isOk()) continue;
                        GSImportWizardModel.this.importStrategy.setValue((Object)other);
                    }
                }
                return null;
            }
        };
        this.downloadStatus = new Validator(){

            protected ValidationResult compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g == null) {
                    return ValidationResult.OK;
                }
                return ValidationResult.from((IStatus)g.getZip().getDownloadStatus());
            }
        };
        this.description = new LiveExpression<String>("<no description>"){

            protected String compute() {
                Object g = GSImportWizardModel.this.rawSelection.getValue();
                if (g != null && g instanceof Describable) {
                    return ((Describable)g).getDescription();
                }
                return "Select Getting Started Content to see its Description";
            }
        };
        this.homePage = new LiveExpression<URL>(null){

            protected URL compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null) {
                    return g.getHomePage();
                }
                return null;
            }
        };
        this.enableOpenHomePage = new LiveVariable((Object)true);
        this.importStrategyValidator.dependsOn(this.guide);
        this.importStrategyValidator.dependsOn(this.isDownloaded);
        this.importStrategyValidator.dependsOn(this.importStrategy);
        this.importStrategyValidator.dependsOn(this.codesets);
        this.isDownloaded.dependsOn(this.guide);
        this.downloadStatus.dependsOn(this.guide);
        this.description.dependsOn(this.rawSelection);
        this.homePage.dependsOn(this.guide);
        this.validCodesetNames.dependsOn(this.guide);
        this.validCodesetNames.dependsOn(this.isDownloaded);
        this.codesetValidator.dependsOn(this.isDownloaded);
    }

    static final ValidationResult isDownloadingMessage(GSContent g) {
        return ValidationResult.info((String)(String.valueOf(g.getDisplayName()) + " is downloading..."));
    }

    private ValidationResult validateImportStrategy(GSContent g, ImportStrategy importStrategy) {
        try {
            if (g != null) {
                try {
                    if (importStrategy == null) {
                        return ValidationResult.error((String)"No build type selected");
                    }
                    List codesetNames = this.codesets.getValues();
                    if (codesetNames != null) {
                        for (String csname : codesetNames) {
                            CodeSet cs = g.getCodeSet(csname);
                            if (cs == null) continue;
                            ValidationResult result = cs.validateBuildType(importStrategy.getBuildType());
                            if (!result.isOk()) {
                                return result.withMessage("CodeSet '" + csname + "': " + result.msg);
                            }
                            if (importStrategy.isSupported()) continue;
                            return ValidationResult.error((String)importStrategy.getNotInstalledMessage());
                        }
                    }
                }
                catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                    this.scheduleDownloadJob();
                    return GSImportWizardModel.isDownloadingMessage(g);
                }
            }
            return ValidationResult.OK;
        }
        catch (Throwable e) {
            BootWizardActivator.log(e);
            return ValidationResult.error((String)ExceptionUtil.getMessage((Throwable)e));
        }
    }

    public void performDownload(IProgressMonitor mon) {
        mon.beginTask("Downloading", 1);
        try {
            try {
                GSContent g = (GSContent)this.guide.getValue();
                if (g != null) {
                    g.getZip().getFile();
                }
            }
            catch (Exception e) {
                BootWizardActivator.log(e);
                this.isDownloaded.refresh();
                this.downloadStatus.refresh();
                mon.done();
            }
        }
        finally {
            this.isDownloaded.refresh();
            this.downloadStatus.refresh();
            mon.done();
        }
    }

    private void scheduleDownloadJob() {
        Job job = new Job("Downloading guide content"){

            protected IStatus run(IProgressMonitor mon) {
                try {
                    GSImportWizardModel.this.performDownload(mon);
                }
                catch (Throwable e) {
                    return ExceptionUtil.status((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public boolean performFinish(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        GSContent g = (GSContent)this.guide.getValue();
        ImportStrategy is = (ImportStrategy)this.importStrategy.getValue();
        Set codesetNames = (Set)this.codesets.getValue();
        mon.beginTask("Import guide content", codesetNames.size() + 1);
        try {
            for (String name : codesetNames) {
                CodeSet cs = g.getCodeSet(name);
                if (cs == null) {
                    mon.worked(1);
                    continue;
                }
                IRunnableWithProgress oper = is.createOperation(ImportUtils.importConfig(g, cs));
                oper.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)mon, (int)1));
            }
            if (((Boolean)this.enableOpenHomePage.getValue()).booleanValue()) {
                this.openHomePage();
            }
            return true;
        }
        catch (UIThreadDownloadDisallowed e) {
            BootWizardActivator.log(e);
            return false;
        }
        finally {
            mon.done();
        }
    }

    public void openHomePage() {
        URL url = (URL)this.homePage.getValue();
        if (url != null) {
            UiUtil.openUrl((String)url.toString());
        }
    }

    public SelectionModel<ImportStrategy> getImportStrategyModel() {
        return new SelectionModel(this.importStrategy, this.importStrategyValidator);
    }

    public SelectionModel<GSContent> getGSContentSelectionModel() {
        return new SelectionModel(this.guide, this.guideValidator);
    }

    public MultiSelectionModel<String> getCodeSetModel() {
        return new MultiSelectionModel<String>(this.codesets, this.codesetValidator);
    }

    public LiveExpression<Boolean> isDownloaded() {
        return this.isDownloaded;
    }

    public LiveVariable<Boolean> getEnableOpenHomePage() {
        return this.enableOpenHomePage;
    }

    public void setItem(GSContent guide) {
        this.guide.setValue((Object)guide);
    }

    public LiveVariable<Object> getRawSelection() {
        return this.rawSelection;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void setContentManager(ContentManager contentManager) {
        this.contentManager = contentManager;
    }

    public class CodeSetValidator
    extends LiveExpression<ValidationResult> {
        private final LiveVariable<GSContent> codesetProvider;
        private final LiveSet<String> selectedNames;
        private final LiveExpression<String[]> validCodesetNames;

        public CodeSetValidator(LiveVariable<GSContent> guide, LiveSet<String> codesets, LiveExpression<String[]> validCodeSetNames) {
            this.codesetProvider = guide;
            this.selectedNames = codesets;
            this.validCodesetNames = validCodeSetNames;
            this.dependsOn((LiveExpression)guide);
            this.dependsOn((LiveExpression)codesets);
            this.dependsOn(validCodeSetNames);
        }

        protected ValidationResult compute() {
            block7: {
                try {
                    GSContent g = (GSContent)this.codesetProvider.getValue();
                    if (g == null) break block7;
                    boolean codesetSelected = false;
                    try {
                        String[] validNames;
                        Set names = (Set)this.selectedNames.getValue();
                        if (names != null && !names.isEmpty()) {
                            for (String name : names) {
                                CodeSet cs = g.getCodeSet(name);
                                if (cs == null) continue;
                                codesetSelected = true;
                                ImportConfiguration conf = ImportUtils.importConfig(g, cs);
                                ValidationResult valid = ImportUtils.validateImportConfiguration(conf);
                                if (valid.isOk()) continue;
                                return valid;
                            }
                        }
                        if (!codesetSelected && (validNames = (String[])this.validCodesetNames.getValue()) != null && validNames.length > 0) {
                            return ValidationResult.error((String)"At least one codeset should be selected");
                        }
                    }
                    catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                        GSImportWizardModel.this.scheduleDownloadJob();
                        return GSImportWizardModel.isDownloadingMessage(g);
                    }
                }
                catch (Throwable e) {
                    BootWizardActivator.log(e);
                    return ValidationResult.error((String)ExceptionUtil.getMessage((Throwable)e));
                }
            }
            return ValidationResult.OK;
        }
    }
}

