/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.guides;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategies;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.GroupSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class ImportStrategiesRadiosSection
extends GroupSection {
    private final SelectionModel<ImportStrategy> selection;

    protected GridLayout createLayout() {
        return new GridLayout(3, true);
    }

    public ImportStrategiesRadiosSection(WizardPageWithSections owner, SelectionModel<ImportStrategy> selection) {
        super((IPageWithSections)owner, "Build Type", ImportStrategiesRadiosSection.createSections(owner, selection));
        this.selection = selection;
    }

    private static WizardPageSection[] createSections(WizardPageWithSections owner, SelectionModel<ImportStrategy> selection) {
        ArrayList<Choice> section = new ArrayList<Choice>();
        for (ImportStrategy strat : ImportStrategies.all()) {
            section.add(new Choice((IPageWithSections)owner, strat, (LiveVariable<ImportStrategy>)selection.selection));
        }
        return section.toArray(new WizardPageSection[section.size()]);
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    private static class Choice
    extends WizardPageSection {
        private final ImportStrategy strategy;
        private final LiveVariable<ImportStrategy> selection;

        public Choice(IPageWithSections owner, ImportStrategy buildType, LiveVariable<ImportStrategy> selection) {
            super(owner);
            this.strategy = buildType;
            this.selection = selection;
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.constant((Object)ValidationResult.OK);
        }

        public void createContents(Composite page) {
            final Button button = new Button(page, 16);
            button.setText(this.strategy.displayName());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
            this.selection.addListener((ValueListener)new UIValueListener<ImportStrategy>(){

                protected void uiGotValue(LiveExpression<ImportStrategy> exp, ImportStrategy value) {
                    button.setSelection(value == strategy);
                }
            });
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        selection.setValue((Object)strategy);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        selection.setValue((Object)strategy);
                    }
                }
            });
        }
    }
}

