/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.guides;

import java.net.URL;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.springframework.ide.eclipse.boot.wizard.guides.GSImportWizard;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class OpenUrlSection
extends WizardPageSection {
    private final LiveExpression<URL> url;
    private final LiveVariable<Boolean> enableOpen;
    private final String sectionLabel;
    private GSImportWizard wizard;

    public OpenUrlSection(GSImportWizard wizard, WizardPageWithSections owner, String sectionLabel, LiveExpression<URL> url, LiveVariable<Boolean> enableOpenOnFinish) {
        super((IPageWithSections)owner);
        this.wizard = wizard;
        this.sectionLabel = sectionLabel;
        this.url = url;
        this.enableOpen = enableOpenOnFinish;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return Validator.OK;
    }

    public void createContents(Composite page) {
        Composite comp;
        if (this.sectionLabel != null) {
            Group group = new Group(page, 0);
            group.setText(this.sectionLabel);
            comp = group;
        } else {
            comp = new Composite(page, 0);
        }
        comp.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        final Link label = new Link(comp, 0);
        final Button checkbox = new Button(comp, 32);
        checkbox.setText("Open");
        checkbox.setToolTipText("Open the url after finishing this wizard");
        checkbox.setSelection(OpenUrlSection.enabled(this.enableOpen));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)label);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)checkbox);
        label.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenUrlSection.this.wizard.openHomePage(true);
            }
        });
        this.url.addListener((ValueListener)new ValueListener<URL>(){

            public void gotValue(LiveExpression<URL> exp, URL value) {
                if (value == null) {
                    label.setText("(None)");
                } else {
                    label.setText("<a href=\"" + value + "\">" + value + "</a>");
                }
                checkbox.setEnabled(value != null);
                comp.layout(new Control[]{label});
            }
        });
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.refresh();
            }

            private void refresh() {
                OpenUrlSection.this.enableOpen.setValue((Object)checkbox.getSelection());
            }
        });
    }

    public static boolean enabled(LiveExpression<Boolean> var) {
        Boolean val = (Boolean)var.getValue();
        return val != null && val != false;
    }
}

