/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.importing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class GeneralProjectStrategy
extends ImportStrategy {
    public GeneralProjectStrategy(BuildType buildType, String name, String notInstalledMessage) {
        super(buildType, name, notInstalledMessage);
    }

    @Override
    public IRunnableWithProgress createOperation(ImportConfiguration conf) {
        return new GeneralProjectImport(conf);
    }

    public static class GeneralProjectImport
    implements IRunnableWithProgress {
        private final String projectName;
        private final File location;
        private final CodeSet codeset;

        public GeneralProjectImport(ImportConfiguration conf) {
            this.projectName = conf.getProjectName();
            this.location = new File(conf.getLocation());
            this.codeset = conf.getCodeSet();
        }

        public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
            mon.beginTask("Create General Project '" + this.projectName + "'", 2);
            try {
                try {
                    this.codeset.createAt(this.location);
                    mon.worked(1);
                    GeneralProjectImport.createGeneralProject(this.projectName, this.location, (IProgressMonitor)new SubProgressMonitor(mon, 1));
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                mon.done();
            }
        }

        public static boolean isDefaultProjectLocation(String projectName, File projectDir) {
            IPath workspaceLoc = Platform.getLocation();
            if (workspaceLoc != null) {
                File defaultLoc = new File(workspaceLoc.toFile(), projectName);
                return defaultLoc.equals(projectDir);
            }
            return false;
        }

        public static IProject createGeneralProject(String projectName, File projectDir, IProgressMonitor mon) throws CoreException {
            mon.beginTask("Create project " + projectName, 3);
            try {
                String expectedName;
                IPath wsLocation;
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IProjectDescription projectDescription = ws.newProjectDescription(projectName);
                Path projectLocation = new Path(projectDir.getAbsolutePath());
                if (!GeneralProjectImport.isDefaultProjectLocation(projectName, projectDir)) {
                    projectDescription.setLocation((IPath)projectLocation);
                }
                if ((wsLocation = ws.getRoot().getLocation()).isPrefixOf((IPath)projectLocation) && wsLocation.segmentCount() + 1 == projectLocation.segmentCount() && !(expectedName = projectDir.getName()).equals(projectName)) {
                    throw ExceptionUtil.coreException((String)("Project-name (" + projectName + ") should match last segment of location (" + projectDir + ")"));
                }
                mon.worked(1);
                IProject project = ws.getRoot().getProject(projectName);
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(mon, 1));
                project.open((IProgressMonitor)new SubProgressMonitor(mon, 1));
                IProject iProject = project;
                return iProject;
            }
            finally {
                mon.done();
            }
        }
    }
}

