/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.importing;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;

public abstract class ImportStrategy {
    private final String name;
    private final BuildType buildType;
    private final String notInstalledMessage;

    public ImportStrategy(BuildType buildType, String name, String notInstalledMessage) {
        this.name = name;
        this.buildType = buildType;
        this.notInstalledMessage = notInstalledMessage;
    }

    public abstract IRunnableWithProgress createOperation(ImportConfiguration var1);

    public boolean isSupported() {
        return true;
    }

    public final String getNotInstalledMessage() {
        return "Can not import using " + this.displayName() + " because " + this.notInstalledMessage;
    }

    public String getName() {
        return this.name;
    }

    public String displayName() {
        if (this.buildType.getImportStrategies().size() > 1) {
            return String.valueOf(this.buildType.displayName()) + " (" + this.name + ")";
        }
        return this.buildType.displayName();
    }

    public IPath getBuildScript() {
        return this.buildType.getBuildScript();
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public String toString() {
        if (this.buildType.getImportStrategies().size() > 1) {
            return (Object)((Object)this.buildType) + "-" + this.name;
        }
        return this.buildType.toString();
    }

    public String getId() {
        String id = this.buildType.toString();
        if (this.buildType.getImportStrategies().size() > 1) {
            id = String.valueOf(id) + "-" + this.name;
        }
        return id;
    }
}

