/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.importing;

import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategyFactory;
import org.springframework.ide.eclipse.boot.wizard.importing.NullImportStrategy;

public class ImportStrategyHolder {
    private BuildType buildType;
    private ImportStrategyFactory factory;
    private String notInstalledMessage;
    private String name;
    private ImportStrategy instance = null;

    public ImportStrategyHolder(BuildType buildType, ImportStrategyFactory factory, String notInstalledMessage, String name) {
        this.buildType = buildType;
        this.factory = factory;
        this.notInstalledMessage = notInstalledMessage;
        this.name = name;
    }

    public ImportStrategy get() {
        if (this.instance == null) {
            try {
                this.instance = this.factory.create(this.buildType, this.name, this.notInstalledMessage);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception e) {
                BootWizardActivator.log(e);
            }
            if (this.instance == null) {
                this.instance = new NullImportStrategy(this.buildType, this.name, this.notInstalledMessage);
            }
        }
        return this.instance;
    }
}

