/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.importing;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.boot.wizard.BootWizardActivator;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.content.GSContent;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class ImportUtils {
    public static ImportConfiguration importConfig(final IPath location, final String projectName, final CodeSet codeset) {
        ImportConfiguration conf = new ImportConfiguration(){

            @Override
            public String getLocation() {
                return location.toString();
            }

            @Override
            public String getProjectName() {
                return projectName;
            }

            @Override
            public CodeSet getCodeSet() {
                return codeset;
            }
        };
        return conf;
    }

    public static ImportConfiguration importConfig(GSContent guide, CodeSet codeset) {
        Assert.isNotNull((Object)guide);
        Assert.isNotNull((Object)codeset);
        String csName = codeset.getName();
        String projectName = "default".equals(csName) ? guide.getName() : (csName.equals(guide.getName()) ? csName : String.valueOf(guide.getName()) + "-" + codeset.getName());
        return ImportUtils.importConfig(Platform.getLocation().append(projectName), projectName, codeset);
    }

    public static ValidationResult validateImportConfiguration(ImportConfiguration conf) {
        try {
            String name = conf.getProjectName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists()) {
                return ValidationResult.error((String)("Project '" + name + "' already exists in the workspace"));
            }
            File loc = new File(conf.getLocation());
            if (loc.exists()) {
                return ValidationResult.error((String)("File or directory exists at '" + loc + "'"));
            }
            File defaultLocation = Platform.getLocation().append(name).toFile();
            if (defaultLocation.exists()) {
                return ValidationResult.error((String)("Project '" + name + "' unavailable: File exists at '" + defaultLocation + "'"));
            }
            return ValidationResult.OK;
        }
        catch (Throwable e) {
            BootWizardActivator.log(e);
            return ValidationResult.error((String)ExceptionUtil.getMessage((Throwable)e));
        }
    }
}

