/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.wizard.importing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;
import org.springframework.ide.eclipse.boot.wizard.content.BuildType;
import org.springframework.ide.eclipse.boot.wizard.content.CodeSet;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportConfiguration;
import org.springframework.ide.eclipse.boot.wizard.importing.ImportStrategy;

public class MavenStrategy
extends ImportStrategy {
    public MavenStrategy(BuildType buildType, String name, String notInstalledMessage) {
        super(buildType, name, notInstalledMessage);
        Assert.isNotNull((Object)Platform.getBundle((String)"org.eclipse.m2e.core"), (String)"M2E is not installed");
    }

    @Override
    public IRunnableWithProgress createOperation(ImportConfiguration conf) {
        return new MavenCodeSetImport(conf);
    }

    protected static void createEclipseProjectFromExistingMavenProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
        String derivedProjectName = model.getName();
        if (derivedProjectName == null) {
            derivedProjectName = model.getArtifactId();
        }
        if (derivedProjectName == null) {
            String[] groupPieces = model.getGroupId().split("\\.");
            int lastIndex = groupPieces.length - 1;
            if (lastIndex >= 0) {
                derivedProjectName = groupPieces[lastIndex];
            } else {
                String message = NLS.bind((String)"Bad pom.xml: no name, artifactId, or groupId.", null);
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.boot.wizard", message));
            }
        }
        MavenProjectInfo parent = null;
        MavenProjectInfo projectInfo = new MavenProjectInfo(derivedProjectName, pomFile, model, parent);
        ArrayList<MavenProjectInfo> projectInfos = new ArrayList<MavenProjectInfo>();
        projectInfos.add(projectInfo);
        ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
        String activeProfiles = "pom.xml";
        resolverConfiguration.setActiveProfiles(activeProfiles);
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(resolverConfiguration);
        List importResults = MavenPlugin.getProjectConfigurationManager().importProjects(projectInfos, configuration, monitor);
        for (IMavenProjectImportResult importResult : importResults) {
            if (importResult.getProject() == null) continue;
            MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(importResult.getProject(), monitor);
        }
    }

    private static class MavenCodeSetImport
    implements IRunnableWithProgress {
        private final String projectName;
        private final File location;
        private final CodeSet codeset;

        public MavenCodeSetImport(ImportConfiguration conf) {
            this.projectName = conf.getProjectName();
            this.location = new File(conf.getLocation());
            this.codeset = conf.getCodeSet();
        }

        public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
            mon.beginTask("Create maven project " + this.projectName, 5);
            Job.getJobManager().beginRule(this.getRule(), (IProgressMonitor)new SubProgressMonitor(mon, 1));
            try {
                try {
                    this.codeset.createAt(this.location);
                    mon.worked(1);
                    File pomFile = new File(this.location, "pom.xml");
                    Assert.isTrue((boolean)pomFile.isFile(), (String)("No pom file found: " + pomFile));
                    Assert.isTrue((pomFile.length() > 0L ? 1 : 0) != 0, (String)("Pom file contains no data: " + pomFile));
                    MavenStrategy.createEclipseProjectFromExistingMavenProject(pomFile, (IProgressMonitor)new SubProgressMonitor(mon, 3));
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                Job.getJobManager().endRule(this.getRule());
                mon.done();
            }
        }

        private ISchedulingRule getRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }
}

