/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinders;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.IReconcileTrigger;
import org.springframework.ide.eclipse.boot.properties.editor.RelaxedNameConfig;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesHyperlinkDetector;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconcilerFactory;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.SpringPropertyProblemQuickAssistProcessor;
import org.springframework.ide.eclipse.boot.properties.editor.util.HyperlinkDetectorUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ApplicationYamlStructureProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.YamlEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.ApplicationYamlAssistContextProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.ApplicationYamlReconcileEngine;
import org.springframework.ide.eclipse.editor.support.ForceableReconciler;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.util.DefaultUserInteractions;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;
import org.springframework.ide.eclipse.editor.support.util.ShellProviders;
import org.springframework.ide.eclipse.editor.support.util.UserInteractions;
import org.springframework.ide.eclipse.editor.support.yaml.AbstractYamlSourceViewerConfiguration;
import org.springframework.ide.eclipse.editor.support.yaml.YamlAssistContextProvider;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureProvider;

public class ApplicationYamlSourceViewerConfiguration
extends AbstractYamlSourceViewerConfiguration
implements IReconcileTrigger {
    public static final DocumentContextFinder documentContextFinder = DocumentContextFinders.YAML_DEFAULT;
    SpringPropertyIndexProvider indexProvider = new SpringPropertyIndexProvider(){

        public FuzzyMap<PropertyInfo> getIndex(IDocument doc) {
            IJavaProject jp = DocumentUtil.getJavaProject((IDocument)doc);
            if (jp != null) {
                return SpringPropertiesEditorPlugin.getIndexManager().get(jp);
            }
            return null;
        }
    };
    TypeUtilProvider typeUtilProvider = new TypeUtilProvider(){

        public TypeUtil getTypeUtil(IDocument doc) {
            return new TypeUtil(DocumentUtil.getJavaProject((IDocument)doc));
        }
    };
    private final YamlStructureProvider structureProvider = ApplicationYamlStructureProvider.INSTANCE;
    private final YamlAssistContextProvider assistContextProvider = new ApplicationYamlAssistContextProvider(this.indexProvider, this.typeUtilProvider, RelaxedNameConfig.COMPLETION_DEFAULTS, documentContextFinder);
    public final SpringPropertiesReconcilerFactory fReconcilerFactory = new SpringPropertiesReconcilerFactory(){

        protected IReconcileEngine createEngine() throws Exception {
            return new ApplicationYamlReconcileEngine(ApplicationYamlSourceViewerConfiguration.this.getAstProvider(), ApplicationYamlSourceViewerConfiguration.this.indexProvider, ApplicationYamlSourceViewerConfiguration.this.typeUtilProvider);
        }
    };
    final PropertyCompletionFactory completionFactory = new PropertyCompletionFactory(documentContextFinder);

    public static void debug(String string) {
        System.out.println(string);
    }

    public ApplicationYamlSourceViewerConfiguration(ITextEditor editor) {
        super(ShellProviders.from((ITextEditor)editor));
    }

    protected Point getDefaultPopupSize() {
        Rectangle windowBounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        int suggestW = (int)((double)windowBounds.width * 0.35);
        int suggestH = (int)((double)suggestW * 0.6);
        if (suggestW > 300) {
            return new Point(suggestW, suggestH);
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 0);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new SpringPropertyProblemQuickAssistProcessor(this.getPreferencesStore(), (UserInteractions)new DefaultUserInteractions(this.getShell())));
        assistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
        return assistant;
    }

    protected IPreferenceStore getPreferencesStore() {
        return SpringPropertiesEditorPlugin.getDefault().getPreferenceStore();
    }

    protected String getPluginId() {
        return "org.springframework.ide.eclipse.boot.properties.editor";
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        SpringPropertiesHyperlinkDetector myDetector = null;
        try {
            myDetector = new SpringPropertiesHyperlinkDetector(this.getHoverProvider());
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log((Throwable)e);
        }
        return HyperlinkDetectorUtil.merge((IHyperlinkDetector[])super.getHyperlinkDetectors(sourceViewer), (IHyperlinkDetector)myDetector);
    }

    public void forceReconcile() {
        if (this.fReconciler != null) {
            this.fReconciler.forceReconcile();
        }
    }

    protected IDialogSettings getPluginDialogSettings() {
        return YamlEditorPlugin.getDefault().getDialogSettings();
    }

    public YamlStructureProvider getStructureProvider() {
        return this.structureProvider;
    }

    public YamlAssistContextProvider getAssistContextProvider() {
        return this.assistContextProvider;
    }

    protected ForceableReconciler createReconciler(ISourceViewer sourceViewer) {
        return this.fReconcilerFactory.createReconciler(sourceViewer, documentContextFinder, (IReconcileTrigger)this);
    }
}

