/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.RelaxedNameConfig;
import org.springframework.ide.eclipse.boot.properties.editor.completions.JavaTypeNavigationHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.LazyProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.completions.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ValueHintHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.HintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.springframework.ide.eclipse.editor.support.completions.CompletionFactory;
import org.springframework.ide.eclipse.editor.support.completions.DocumentEdits;
import org.springframework.ide.eclipse.editor.support.completions.ProposalApplier;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springframework.ide.eclipse.editor.support.util.YamlIndentUtil;
import org.springframework.ide.eclipse.editor.support.yaml.YamlDocument;
import org.springframework.ide.eclipse.editor.support.yaml.completions.AbstractYamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.TopLevelAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlPathEdits;
import org.springframework.ide.eclipse.editor.support.yaml.completions.YamlUtil;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlNavigable;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPath;
import org.springframework.ide.eclipse.editor.support.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YType;
import org.springframework.ide.eclipse.editor.support.yaml.structure.YamlStructureParser;

public abstract class ApplicationYamlAssistContext
extends AbstractYamlAssistContext {
    protected final RelaxedNameConfig conf;
    public final TypeUtil typeUtil;

    public ApplicationYamlAssistContext(int documentSelector, YamlPath contextPath, TypeUtil typeUtil, RelaxedNameConfig conf) {
        super(documentSelector, contextPath);
        this.typeUtil = typeUtil;
        this.conf = conf;
    }

    protected String appendTextFor(Type type) {
        if (TypeUtil.isMap((Type)type)) {
            return "\n" + YamlIndentUtil.INDENT_STR;
        }
        if (TypeUtil.isSequencable((Type)type)) {
            return "\n- ";
        }
        if (this.typeUtil.isAtomic(type)) {
            return " ";
        }
        return "\n" + YamlIndentUtil.INDENT_STR;
    }

    protected abstract Type getType();

    public static ApplicationYamlAssistContext subdocument(int documentSelector, FuzzyMap<PropertyInfo> index, PropertyCompletionFactory completionFactory, TypeUtil typeUtil, RelaxedNameConfig conf) {
        return new IndexContext(documentSelector, YamlPath.EMPTY, IndexNavigator.with(index), completionFactory, typeUtil, conf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YamlAssistContext forPath(YamlPath contextPath, FuzzyMap<PropertyInfo> index, PropertyCompletionFactory completionFactory, TypeUtil typeUtil, RelaxedNameConfig conf) {
        try {
            YamlPathSegment documentSelector = contextPath.getSegment(0);
            if (documentSelector == null) return null;
            contextPath = contextPath.dropFirst(1);
            ApplicationYamlAssistContext context = ApplicationYamlAssistContext.subdocument(documentSelector.toIndex(), index, completionFactory, typeUtil, conf);
            YamlPathSegment[] yamlPathSegmentArray = contextPath.getSegments();
            int n = yamlPathSegmentArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return context;
                }
                YamlPathSegment s = yamlPathSegmentArray[n2];
                if (context == null) {
                    return null;
                }
                context = (YamlAssistContext)context.traverse(s);
                ++n2;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public abstract YamlAssistContext traverse(YamlPathSegment var1) throws Exception;

    public abstract HoverInfo getHoverInfo();

    public HoverInfo getHoverInfo(YamlPathSegment s) {
        return null;
    }

    public static YamlAssistContext global(final FuzzyMap<PropertyInfo> index, final PropertyCompletionFactory completionFactory, final TypeUtil typeUtil, final RelaxedNameConfig conf) {
        return new TopLevelAssistContext(){

            protected YamlAssistContext getDocumentContext(int documentSelector) {
                return ApplicationYamlAssistContext.subdocument(documentSelector, (FuzzyMap<PropertyInfo>)index, completionFactory, typeUtil, conf);
            }
        };
    }

    private static class IndexContext
    extends ApplicationYamlAssistContext {
        private IndexNavigator indexNav;
        PropertyCompletionFactory completionFactory;

        public IndexContext(int documentSelector, YamlPath contextPath, IndexNavigator indexNav, PropertyCompletionFactory completionFactory, TypeUtil typeUtil, RelaxedNameConfig conf) {
            super(documentSelector, contextPath, typeUtil, conf);
            this.indexNav = indexNav;
            this.completionFactory = completionFactory;
        }

        public Collection<ICompletionProposal> getCompletions(YamlDocument doc, YamlStructureParser.SNode node, int offset) throws Exception {
            String query = this.getPrefix(doc, node, offset);
            List<FuzzyMap.Match<PropertyInfo>> matchingProps = this.indexNav.findMatching(query);
            if (!matchingProps.isEmpty()) {
                ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
                for (FuzzyMap.Match match : matchingProps) {
                    ProposalApplier edits = this.createEdits(doc, offset, query, (FuzzyMap.Match<PropertyInfo>)match);
                    CompletionFactory.ScoreableProposal completion = this.completionFactory.property(doc.getDocument(), edits, match, this.typeUtil);
                    if (this.getContextRoot(doc).exists(YamlPath.fromProperty((String)((PropertyInfo)match.data).getId()))) {
                        completion.deemphasize();
                    }
                    completions.add((ICompletionProposal)completion);
                }
                return completions;
            }
            return Collections.emptyList();
        }

        protected ProposalApplier createEdits(final YamlDocument file, final int offset, final String query, final FuzzyMap.Match<PropertyInfo> match) throws Exception {
            return new LazyProposalApplier(){

                protected ProposalApplier create() throws Exception {
                    YamlPathEdits edits = new YamlPathEdits(file);
                    int queryOffset = offset - query.length();
                    edits.delete(queryOffset, query);
                    YamlPath propertyPath = YamlPath.fromProperty((String)((PropertyInfo)match.data).getId());
                    YamlPath relativePath = propertyPath.dropFirst(contextPath.size());
                    YamlPathSegment nextSegment = relativePath.getSegment(0);
                    YamlStructureParser.SNode contextNode = this.getContextNode(file);
                    YamlStructureParser.SNode existingNode = contextNode.traverse(nextSegment);
                    String appendText = this.appendTextFor(TypeParser.parse((String)((PropertyInfo)match.data).getType()));
                    if (existingNode == null) {
                        edits.createPathInPlace(contextNode, relativePath, queryOffset, appendText);
                    } else {
                        String wholeLine = file.getLineTextAtOffset(queryOffset);
                        if (wholeLine.trim().equals(query.trim())) {
                            edits.deleteLineBackwardAtOffset(queryOffset);
                        }
                        edits.createPath((YamlStructureParser.SChildBearingNode)this.getContextRoot(file), YamlPath.fromProperty((String)((PropertyInfo)match.data).getId()), appendText);
                    }
                    return edits;
                }
            };
        }

        public AbstractYamlAssistContext traverse(YamlPathSegment s) {
            if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
                IndexNavigator aliasedSubIndex;
                String keyAlias;
                String key = s.toPropString();
                IndexNavigator subIndex = this.indexNav.selectSubProperty(key);
                if (subIndex.isEmpty() && !(keyAlias = StringUtil.camelCaseToHyphens((String)key)).equals(key) && !(aliasedSubIndex = this.indexNav.selectSubProperty(keyAlias)).isEmpty()) {
                    subIndex = aliasedSubIndex;
                }
                if (subIndex.getExtensionCandidate() != null) {
                    return new IndexContext(this.documentSelector, this.contextPath.append(s), subIndex, this.completionFactory, this.typeUtil, this.conf);
                }
                if (subIndex.getExactMatch() != null) {
                    IndexContext asIndexContext = new IndexContext(this.documentSelector, this.contextPath.append(s), subIndex, this.completionFactory, this.typeUtil, this.conf);
                    PropertyInfo prop = subIndex.getExactMatch();
                    return new TypeContext(asIndexContext, this.contextPath.append(s), TypeParser.parse((String)prop.getType()), this.completionFactory, this.typeUtil, this.conf, prop.getHints(this.typeUtil, true));
                }
            }
            return null;
        }

        public String toString() {
            return "YamlAssistIndexContext(" + this.indexNav + ")";
        }

        @Override
        protected Type getType() {
            PropertyInfo match = this.indexNav.getExactMatch();
            if (match != null) {
                return TypeParser.parse((String)match.getType());
            }
            return null;
        }

        @Override
        public HoverInfo getHoverInfo() {
            PropertyInfo prop = this.indexNav.getExactMatch();
            if (prop != null) {
                return new SpringPropertyHoverInfo(this.typeUtil.getJavaProject(), prop);
            }
            return null;
        }
    }

    private static class TypeContext
    extends ApplicationYamlAssistContext {
        private PropertyCompletionFactory completionFactory;
        private Type type;
        private ApplicationYamlAssistContext parent;
        private HintProvider hints;

        public TypeContext(ApplicationYamlAssistContext parent, YamlPath contextPath, Type type, PropertyCompletionFactory completionFactory, TypeUtil typeUtil, RelaxedNameConfig conf, HintProvider hints) {
            super(parent.documentSelector, contextPath, typeUtil, conf);
            this.parent = parent;
            this.completionFactory = completionFactory;
            this.type = type;
            this.hints = hints;
        }

        private HintProvider getHintProvider() {
            return this.hints;
        }

        public Collection<ICompletionProposal> getCompletions(YamlDocument doc, YamlStructureParser.SNode node, int offset) throws Exception {
            String query = this.getPrefix(doc, node, offset);
            TypeUtil.EnumCaseMode enumCaseMode = this.enumCaseMode(query);
            TypeUtil.BeanPropertyNameMode beanMode = this.conf.getBeanMode();
            List<ICompletionProposal> valueCompletions = this.getValueCompletions(doc, offset, query, enumCaseMode);
            if (!valueCompletions.isEmpty()) {
                return valueCompletions;
            }
            return this.getKeyCompletions(doc, offset, query, enumCaseMode, beanMode);
        }

        private TypeUtil.EnumCaseMode enumCaseMode(String query) {
            if (query.isEmpty()) {
                return this.conf.getEnumMode();
            }
            return TypeUtil.EnumCaseMode.ALIASED;
        }

        public List<ICompletionProposal> getKeyCompletions(YamlDocument doc, int offset, String query, TypeUtil.EnumCaseMode enumCaseMode, TypeUtil.BeanPropertyNameMode beanMode) throws Exception {
            int queryOffset = offset - query.length();
            List<TypedProperty> properties = this.getProperties(query, enumCaseMode, beanMode);
            if (CollectionUtil.hasElements(properties)) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(properties.size());
                YamlStructureParser.SNode contextNode = this.getContextNode(doc);
                Set<String> definedProps = this.getDefinedProperties(contextNode);
                for (TypedProperty p : properties) {
                    String name = p.getName();
                    double score = FuzzyMatcher.matchScore((String)query, (String)name);
                    if (score == 0.0) continue;
                    YamlPath relativePath = YamlPath.fromSimpleProperty((String)name);
                    YamlPathEdits edits = new YamlPathEdits(doc);
                    if (!definedProps.contains(name)) {
                        Type type = p.getType();
                        edits.delete(queryOffset, query);
                        edits.createPathInPlace(contextNode, relativePath, queryOffset, this.appendTextFor(type));
                        proposals.add((ICompletionProposal)this.completionFactory.beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, (ProposalApplier)edits, this.typeUtil));
                        continue;
                    }
                    TypeContext.deleteQueryAndLine((YamlDocument)doc, (String)query, (int)queryOffset, (YamlPathEdits)edits);
                    edits.createPath((YamlStructureParser.SChildBearingNode)contextNode, relativePath, "");
                    proposals.add((ICompletionProposal)this.completionFactory.beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, (ProposalApplier)edits, this.typeUtil).deemphasize());
                }
                return proposals;
            }
            return Collections.emptyList();
        }

        protected List<TypedProperty> getProperties(String query, TypeUtil.EnumCaseMode enumCaseMode, TypeUtil.BeanPropertyNameMode beanMode) {
            List fromHints;
            HintProvider hints;
            ArrayList<TypedProperty> props = new ArrayList<TypedProperty>();
            List fromType = this.typeUtil.getProperties(this.type, enumCaseMode, beanMode);
            if (CollectionUtil.hasElements((Collection)fromType)) {
                props.addAll(fromType);
            }
            if ((hints = this.getHintProvider()) != null && CollectionUtil.hasElements((Collection)(fromHints = hints.getPropertyHints(query)))) {
                props.addAll(fromHints);
            }
            return props;
        }

        private Set<String> getDefinedProperties(YamlStructureParser.SNode contextNode) {
            try {
                List children;
                if (contextNode instanceof YamlStructureParser.SChildBearingNode && CollectionUtil.hasElements((Collection)(children = ((YamlStructureParser.SChildBearingNode)contextNode).getChildren()))) {
                    HashSet<String> keys = new HashSet<String>(children.size());
                    for (YamlStructureParser.SNode c : children) {
                        if (!(c instanceof YamlStructureParser.SKeyNode)) continue;
                        keys.add(((YamlStructureParser.SKeyNode)c).getKey());
                    }
                    return keys;
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
            return Collections.emptySet();
        }

        private List<ICompletionProposal> getValueCompletions(YamlDocument doc, int offset, String query, TypeUtil.EnumCaseMode enumCaseMode) {
            Collection<StsValueHint> hints = this.getHintValues(query, doc, offset, enumCaseMode);
            if (hints != null) {
                ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
                for (StsValueHint hint : hints) {
                    String value = hint.getValue();
                    double score = FuzzyMatcher.matchScore((String)query, (String)value);
                    if (score == 0.0 || value.equals(query)) continue;
                    DocumentEdits edits = new DocumentEdits(doc.getDocument());
                    int valueStart = offset - query.length();
                    edits.delete(valueStart, offset);
                    if (doc.getChar(valueStart - 1) == ':') {
                        edits.insert(offset, " ");
                    }
                    edits.insert(offset, YamlUtil.stringEscape((String)value));
                    completions.add((ICompletionProposal)this.completionFactory.valueProposal(value, query, (YType)this.type, score, (ProposalApplier)edits, (HoverInfo)new ValueHintHoverInfo(hint)));
                }
                return completions;
            }
            return Collections.emptyList();
        }

        public HoverInfo getValueHoverInfo(YamlDocument doc, DocumentRegion valueRegion) {
            StsValueHint hint;
            String value = valueRegion.toString();
            if (TypeUtil.isClass((Type)this.type) && (hint = StsValueHint.className((String)value.toString(), (TypeUtil)this.typeUtil)) != null) {
                return new ValueHintHoverInfo(hint);
            }
            Collection<StsValueHint> hints = this.getHintValues(value, doc, valueRegion.getEnd(), TypeUtil.EnumCaseMode.ALIASED);
            for (StsValueHint h : hints) {
                if (!value.equals(h.getValue())) continue;
                return new ValueHintHoverInfo(h);
            }
            return super.getValueHoverInfo(doc, valueRegion);
        }

        protected Collection<StsValueHint> getHintValues(String query, YamlDocument doc, int offset, TypeUtil.EnumCaseMode enumCaseMode) {
            HintProvider hintProvider;
            ArrayList<StsValueHint> allHints = new ArrayList<StsValueHint>();
            Collection hints = this.typeUtil.getHintValues(this.type, query, enumCaseMode);
            if (CollectionUtil.hasElements((Collection)hints)) {
                allHints.addAll(hints);
            }
            if ((hintProvider = this.getHintProvider()) != null) {
                allHints.addAll(hintProvider.getValueHints(query));
            }
            return allHints;
        }

        @Override
        public YamlAssistContext traverse(YamlPathSegment s) {
            if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
                if (TypeUtil.isSequencable((Type)this.type) || TypeUtil.isMap((Type)this.type)) {
                    return this.contextWith(s, TypeUtil.getDomainType((Type)this.type));
                }
                String key = s.toPropString();
                Map subproperties = this.typeUtil.getPropertiesMap(this.type, TypeUtil.EnumCaseMode.ALIASED, TypeUtil.BeanPropertyNameMode.ALIASED);
                if (subproperties != null) {
                    return this.contextWith(s, TypedProperty.typeOf((TypedProperty)((TypedProperty)subproperties.get(key))));
                }
            } else if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_INDEX && TypeUtil.isSequencable((Type)this.type)) {
                return this.contextWith(s, TypeUtil.getDomainType((Type)this.type));
            }
            return null;
        }

        private AbstractYamlAssistContext contextWith(YamlPathSegment s, Type nextType) {
            if (nextType != null) {
                return new TypeContext(this, this.contextPath.append(s), nextType, this.completionFactory, this.typeUtil, this.conf, (HintProvider)new YamlPath(new YamlPathSegment[]{s}).traverse((YamlNavigable)this.hints));
            }
            return null;
        }

        public String toString() {
            return "TypeContext(" + this.contextPath.toPropString() + "::" + this.type + ")";
        }

        @Override
        public HoverInfo getHoverInfo() {
            if (this.parent instanceof IndexContext) {
                return this.parent.getHoverInfo();
            }
            return new JavaTypeNavigationHoverInfo(this.contextPath.toPropString(), this.contextPath.getBeanPropertyName(), this.parent.getType(), this.getType(), this.typeUtil);
        }

        @Override
        protected Type getType() {
            return this.type;
        }
    }
}

